/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.ExprCountNodeFactory;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;

public class ExprCountNode
extends ExprAggregateNodeBase {
    private static final long serialVersionUID = 1859320277242087598L;
    private final boolean hasFilter;

    public ExprCountNode(boolean distinct, boolean hasFilter) {
        super(distinct);
        this.hasFilter = hasFilter;
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() > 2) {
            throw new ExprValidationException("Count node must have less then 2 child nodes");
        }
        Class childType = null;
        boolean ignoreNulls = false;
        if (!this.getChildNodes().isEmpty()) {
            if (this.getChildNodes().size() == 1) {
                if (!this.hasFilter) {
                    childType = this.getChildNodes().get(0).getExprEvaluator().getType();
                    ignoreNulls = true;
                } else {
                    super.validateFilter(this.getChildNodes().get(0).getExprEvaluator());
                }
            } else if (this.getChildNodes().size() == 2) {
                childType = this.getChildNodes().get(0).getExprEvaluator().getType();
                ignoreNulls = true;
            }
        }
        return new ExprCountNodeFactory(ignoreNulls, this.isDistinct, childType, this.hasFilter);
    }

    @Override
    protected String getAggregationFunctionName() {
        return "count";
    }

    @Override
    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        return node instanceof ExprCountNode;
    }
}

