/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalTypeInfo;
import com.espertech.esper.epl.expression.ExprDotEval;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprDotMethodEvalDuck
implements ExprDotEval {
    private static final Log log = LogFactory.getLog(ExprDotMethodEvalDuck.class);
    private final String statementName;
    private final MethodResolutionService methodResolutionService;
    private final String methodName;
    private final Class[] parameterTypes;
    private final ExprEvaluator[] parameters;
    private Map<Class, FastMethod> cache;

    public ExprDotMethodEvalDuck(String statementName, MethodResolutionService methodResolutionService, String methodName, Class[] parameterTypes, ExprEvaluator[] parameters) {
        this.statementName = statementName;
        this.methodResolutionService = methodResolutionService;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.parameters = parameters;
        this.cache = new HashMap<Class, FastMethod>();
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        FastMethod method;
        if (target == null) {
            return null;
        }
        if (this.cache.containsKey(target.getClass())) {
            method = this.cache.get(target.getClass());
        } else {
            method = this.getFastMethod(target.getClass());
            this.cache.put(target.getClass(), method);
        }
        if (method == null) {
            return null;
        }
        Object[] args = new Object[this.parameters.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.parameters[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            String message = JavaClassHelper.getMessageInvocationTarget(this.statementName, method.getJavaMethod(), target.getClass().getName(), args, e);
            log.error((Object)message, e.getTargetException());
            return null;
        }
    }

    private FastMethod getFastMethod(Class clazz) {
        try {
            Method method = this.methodResolutionService.resolveMethod(clazz, this.methodName, this.parameterTypes);
            FastClass declaringClass = FastClass.create((ClassLoader)Thread.currentThread().getContextClassLoader(), method.getDeclaringClass());
            return declaringClass.getMethod(method);
        }
        catch (Exception e) {
            log.debug((Object)("Not resolved for class '" + clazz.getName() + "' method '" + this.methodName + "'"));
            return null;
        }
    }

    @Override
    public ExprDotEvalTypeInfo getTypeInfo() {
        return ExprDotEvalTypeInfo.scalarOrUnderlying(Object.class);
    }
}

