/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventPropertyGetterIndexed;
import com.espertech.esper.client.EventPropertyGetterMapped;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.datetime.eval.ExprDotNodeFilterAnalyzerDesc;
import com.espertech.esper.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalTypeInfo;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrapFactory;
import com.espertech.esper.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorEventCollection;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorNonLambda;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorScalarArray;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorScalarCollection;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorScalarIterable;
import com.espertech.esper.epl.expression.ExprChainedSpec;
import com.espertech.esper.epl.expression.ExprDotEval;
import com.espertech.esper.epl.expression.ExprDotEvalPropertyExprIndexed;
import com.espertech.esper.epl.expression.ExprDotEvalPropertyExprMapped;
import com.espertech.esper.epl.expression.ExprDotEvalRootChild;
import com.espertech.esper.epl.expression.ExprDotEvalStaticMethod;
import com.espertech.esper.epl.expression.ExprDotEvalStreamEventBean;
import com.espertech.esper.epl.expression.ExprDotEvalStreamMethod;
import com.espertech.esper.epl.expression.ExprDotEvalTransposeAsStream;
import com.espertech.esper.epl.expression.ExprDotNodeFilterAnalyzerInputExpr;
import com.espertech.esper.epl.expression.ExprDotNodeFilterAnalyzerInputProp;
import com.espertech.esper.epl.expression.ExprDotNodeFilterAnalyzerInputStatic;
import com.espertech.esper.epl.expression.ExprDotNodeFilterAnalyzerInputStream;
import com.espertech.esper.epl.expression.ExprDotNodeRealizedChain;
import com.espertech.esper.epl.expression.ExprDotNodeUtility;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprIdentNodeImpl;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeInnerNodeProvider;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprNodeVisitor;
import com.espertech.esper.epl.expression.ExprNodeVisitorWithParent;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.ExprValidationPropertyException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class ExprDotNode
extends ExprNodeBase
implements ExprNodeInnerNodeProvider {
    private static final long serialVersionUID = 8105121208330622813L;
    private final List<ExprChainedSpec> chainSpec;
    private final boolean isDuckTyping;
    private final boolean isUDFCache;
    private transient ExprEvaluator exprEvaluator;
    private boolean isReturnsConstantResult;
    private transient ExprDotNodeFilterAnalyzerDesc exprDotNodeFilterAnalyzerDesc;

    public ExprDotNode(List<ExprChainedSpec> chainSpec, boolean isDuckTyping, boolean isUDFCache) {
        this.chainSpec = chainSpec;
        this.isDuckTyping = isDuckTyping;
        this.isUDFCache = isUDFCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        FastMethod staticMethod;
        Method method;
        ExprNodeUtility.validate(this.chainSpec, validationContext);
        boolean hasEnumerationMethod = false;
        for (ExprChainedSpec chain : this.chainSpec) {
            if (!EnumMethodEnum.isEnumerationMethod(chain.getName())) continue;
            hasEnumerationMethod = true;
            break;
        }
        int prefixedStreamNumber = this.prefixedStreamName(this.chainSpec, validationContext.getStreamTypeService());
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        if (!this.getChildNodes().isEmpty()) {
            ExprNode rootNode = this.getChildNodes().get(0);
            ExprEvaluator rootNodeEvaluator = rootNode.getExprEvaluator();
            Pair<ExprEvaluatorEnumeration, ExprDotEvalTypeInfo> enumSrc = ExprDotNode.getEnumerationSource(rootNode, validationContext.getStreamTypeService(), validationContext.getEventAdapterService(), validationContext.getStatementId(), hasEnumerationMethod);
            ExprDotEvalTypeInfo typeInfo = enumSrc.getSecond() == null ? ExprDotEvalTypeInfo.scalarOrUnderlying(rootNodeEvaluator.getType()) : enumSrc.getSecond();
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(typeInfo, this.chainSpec, validationContext, this.isDuckTyping, new ExprDotNodeFilterAnalyzerInputExpr());
            this.exprEvaluator = new ExprDotEvalRootChild(rootNodeEvaluator, enumSrc.getFirst(), enumSrc.getSecond(), evals.getChain(), evals.getChainWithUnpack());
            return;
        }
        if (this.chainSpec.size() == 1) {
            ExprChainedSpec spec = this.chainSpec.get(0);
            if (spec.getParameters().isEmpty()) {
                throw new ExprValidationException("Unknown single-row function or aggregation function named '" + spec.getName() + "' could not be resolved");
            }
            Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
            try {
                if (!streamTypeService.hasPropertyAgnosticType()) {
                    propertyInfoPair = ExprIdentNodeImpl.getTypeFromStream(streamTypeService, spec.getName());
                }
            }
            catch (ExprValidationPropertyException ex) {
                // empty catch block
            }
            if (propertyInfoPair == null && spec.getName().toLowerCase().equals("transpose")) {
                if (spec.getParameters().size() != 1) {
                    throw new ExprValidationException("The transpose function requires a single parameter expression");
                }
                this.exprEvaluator = new ExprDotEvalTransposeAsStream(this.chainSpec.get(0).getParameters().get(0).getExprEvaluator());
                return;
            } else {
                if (spec.getParameters().size() != 1) {
                    throw new ExprValidationException("Unknown single-row function or aggregation function named '" + spec.getName() + "' could not be resolved");
                }
                if (propertyInfoPair == null) {
                    throw new ExprValidationException("Unknown single-row function, aggregation function or mapped or indexed property named '" + spec.getName() + "' could not be resolved");
                }
                this.exprEvaluator = this.getPropertyPairEvaluator(spec.getParameters().get(0).getExprEvaluator(), propertyInfoPair, validationContext);
            }
            return;
        }
        if (prefixedStreamNumber != -1) {
            ExprChainedSpec specAfterStreamName = this.chainSpec.get(1);
            Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
            try {
                if (!streamTypeService.hasPropertyAgnosticType()) {
                    String propName = this.chainSpec.get(0).getName() + "." + specAfterStreamName.getName();
                    propertyInfoPair = ExprIdentNodeImpl.getTypeFromStream(streamTypeService, propName);
                }
            }
            catch (ExprValidationPropertyException ex) {
                // empty catch block
            }
            if (propertyInfoPair != null) {
                if (specAfterStreamName.getParameters().size() != 1) {
                    throw new ExprValidationException("Unknown single-row function or aggregation function named '" + specAfterStreamName.getName() + "' could not be resolved");
                }
                this.exprEvaluator = this.getPropertyPairEvaluator(specAfterStreamName.getParameters().get(0).getExprEvaluator(), propertyInfoPair, validationContext);
                return;
            }
            EventType eventType = validationContext.getStreamTypeService().getEventTypes()[prefixedStreamNumber];
            Class type = eventType.getUnderlyingType();
            ArrayList<ExprChainedSpec> remainderChain = new ArrayList<ExprChainedSpec>(this.chainSpec);
            remainderChain.remove(0);
            ExprValidationException methodEx = null;
            ExprDotEval[] underlyingMethodChain = null;
            try {
                ExprDotEvalTypeInfo typeInfo = ExprDotEvalTypeInfo.scalarOrUnderlying(type);
                underlyingMethodChain = ExprDotNodeUtility.getChainEvaluators(typeInfo, remainderChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStream(prefixedStreamNumber)).getChainWithUnpack();
            }
            catch (ExprValidationException ex) {
                methodEx = ex;
            }
            ExprDotEval[] eventTypeMethodChain = null;
            ExprValidationException enumDatetimeEx = null;
            try {
                ExprDotEvalTypeInfo typeInfo = ExprDotEvalTypeInfo.event(eventType);
                ExprDotNodeRealizedChain chain = ExprDotNodeUtility.getChainEvaluators(typeInfo, remainderChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStream(prefixedStreamNumber));
                eventTypeMethodChain = chain.getChainWithUnpack();
                this.exprDotNodeFilterAnalyzerDesc = chain.getFilterAnalyzerDesc();
            }
            catch (ExprValidationException ex) {
                enumDatetimeEx = ex;
            }
            if (underlyingMethodChain != null) {
                this.exprEvaluator = new ExprDotEvalStreamMethod(prefixedStreamNumber, underlyingMethodChain);
                return;
            }
            if (eventTypeMethodChain != null) {
                this.exprEvaluator = new ExprDotEvalStreamEventBean(prefixedStreamNumber, eventTypeMethodChain);
                return;
            }
            if (!ExprDotNodeUtility.isDatetimeOrEnumMethod(((ExprChainedSpec)remainderChain.get(0)).getName())) throw new ExprValidationException("Failed to solve '" + ((ExprChainedSpec)remainderChain.get(0)).getName() + "' to either an date-time or enumeration method, an event property or a method on the event underlying object", methodEx);
            throw enumDatetimeEx;
        }
        ArrayList<ExprChainedSpec> modifiedChain = new ArrayList<ExprChainedSpec>(this.chainSpec);
        ExprChainedSpec firstItem = (ExprChainedSpec)modifiedChain.remove(0);
        Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
        try {
            if (!streamTypeService.hasPropertyAgnosticType()) {
                propertyInfoPair = ExprIdentNodeImpl.getTypeFromStream(streamTypeService, firstItem.getName());
            }
        }
        catch (ExprValidationPropertyException ex) {
            // empty catch block
        }
        if (propertyInfoPair != null) {
            int streamId = ((PropertyResolutionDescriptor)propertyInfoPair.getFirst()).getStreamNum();
            EventType streamType = streamTypeService.getEventTypes()[streamId];
            EventPropertyGetter getter = streamType.getGetter(propertyInfoPair.getFirst().getPropertyName());
            Pair<ExprEvaluatorEnumeration, ExprDotEvalTypeInfo> propertyEval = ExprDotNode.getPropertyEnumerationSource(propertyInfoPair.getFirst().getPropertyName(), streamId, streamType, hasEnumerationMethod);
            PropertyExprEvaluatorNonLambda rootNodeEvaluator = new PropertyExprEvaluatorNonLambda(streamId, getter, propertyInfoPair.getFirst().getPropertyType());
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(propertyEval.getSecond(), modifiedChain, validationContext, this.isDuckTyping, new ExprDotNodeFilterAnalyzerInputProp(propertyInfoPair.getFirst().getStreamNum(), propertyInfoPair.getFirst().getPropertyName()));
            this.exprEvaluator = new ExprDotEvalRootChild(rootNodeEvaluator, propertyEval.getFirst(), propertyEval.getSecond(), evals.getChain(), evals.getChainWithUnpack());
            this.exprDotNodeFilterAnalyzerDesc = evals.getFilterAnalyzerDesc();
            return;
        }
        ExprChainedSpec secondItem = (ExprChainedSpec)modifiedChain.remove(0);
        Class[] paramTypes = new Class[secondItem.getParameters().size()];
        ExprEvaluator[] childEvals = new ExprEvaluator[secondItem.getParameters().size()];
        int count = 0;
        boolean allConstants = true;
        for (ExprNode childNode : secondItem.getParameters()) {
            ExprEvaluator eval;
            if (childNode instanceof ExprLambdaGoesNode) {
                throw new ExprValidationException("Unexpected lambda-expression encountered as parameter to UDF or static method '" + secondItem.getName() + "' and failed to resolve '" + firstItem.getName() + "' as a property");
            }
            childEvals[count] = eval = childNode.getExprEvaluator();
            paramTypes[count] = eval.getType();
            ++count;
            if (childNode.isConstantResult()) continue;
            allConstants = false;
        }
        boolean isConstantParameters = allConstants && this.isUDFCache;
        this.isReturnsConstantResult = isConstantParameters && modifiedChain.isEmpty();
        String className = firstItem.getName();
        try {
            method = validationContext.getMethodResolutionService().resolveMethod(firstItem.getName(), secondItem.getName(), paramTypes);
            FastClass declaringClass = FastClass.create((ClassLoader)Thread.currentThread().getContextClassLoader(), method.getDeclaringClass());
            staticMethod = declaringClass.getMethod(method);
        }
        catch (Exception e) {
            String message = "Failed to resolve '" + firstItem.getName() + "' to a property, stream or class name: " + e.getMessage();
            throw new ExprValidationException(message, e);
        }
        ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(method, validationContext.getEventAdapterService(), modifiedChain);
        ExprDotEvalTypeInfo typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : ExprDotEvalTypeInfo.scalarOrUnderlying(method.getReturnType());
        ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
        this.exprEvaluator = new ExprDotEvalStaticMethod(validationContext.getStatementName(), className, staticMethod, childEvals, isConstantParameters, optionalLambdaWrap, evals.getChainWithUnpack());
    }

    public ExprDotNodeFilterAnalyzerDesc getExprDotNodeFilterAnalyzerDesc() {
        return this.exprDotNodeFilterAnalyzerDesc;
    }

    private ExprEvaluator getPropertyPairEvaluator(ExprEvaluator parameterEval, Pair<PropertyResolutionDescriptor, String> propertyInfoPair, ExprValidationContext validationContext) throws ExprValidationException {
        String propertyName = propertyInfoPair.getFirst().getPropertyName();
        EventPropertyDescriptor propertyDesc = propertyInfoPair.getFirst().getStreamEventType().getPropertyDescriptor(propertyName);
        if (propertyDesc == null || !propertyDesc.isMapped() && !propertyDesc.isIndexed()) {
            throw new ExprValidationException("Unknown single-row function, aggregation function or mapped or indexed property named '" + propertyName + "' could not be resolved");
        }
        int streamNum = propertyInfoPair.getFirst().getStreamNum();
        if (propertyDesc.isMapped()) {
            if (parameterEval.getType() != String.class) {
                throw new ExprValidationException("Parameter expression to mapped property '" + propertyDesc.getPropertyName() + "' is expected to return a string-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(parameterEval.getType()));
            }
            EventPropertyGetterMapped mappedGetter = propertyInfoPair.getFirst().getStreamEventType().getGetterMapped(propertyInfoPair.getFirst().getPropertyName());
            if (mappedGetter == null) {
                throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
            }
            return new ExprDotEvalPropertyExprMapped(validationContext.getStatementName(), propertyDesc.getPropertyName(), streamNum, parameterEval, propertyDesc.getPropertyType(), mappedGetter);
        }
        if (JavaClassHelper.getBoxedType(parameterEval.getType()) != Integer.class) {
            throw new ExprValidationException("Parameter expression to mapped property '" + propertyDesc.getPropertyName() + "' is expected to return a Integer-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(parameterEval.getType()));
        }
        EventPropertyGetterIndexed indexedGetter = propertyInfoPair.getFirst().getStreamEventType().getGetterIndexed(propertyInfoPair.getFirst().getPropertyName());
        if (indexedGetter == null) {
            throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
        }
        return new ExprDotEvalPropertyExprIndexed(validationContext.getStatementName(), propertyDesc.getPropertyName(), streamNum, parameterEval, propertyDesc.getPropertyType(), indexedGetter);
    }

    private int prefixedStreamName(List<ExprChainedSpec> chainSpec, StreamTypeService streamTypeService) {
        if (chainSpec.size() < 1) {
            return -1;
        }
        ExprChainedSpec spec = chainSpec.get(0);
        if (spec.getParameters().size() > 0 && !spec.isProperty()) {
            return -1;
        }
        return streamTypeService.getStreamNumForStreamName(spec.getName());
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec, this);
    }

    @Override
    public void replaceUnlistedChildNode(ExprNode nodeToReplace, ExprNode newNode) {
        ExprNodeUtility.replaceChainChildNode(nodeToReplace, newNode, this.chainSpec);
    }

    public List<ExprChainedSpec> getChainSpec() {
        return this.chainSpec;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.exprEvaluator;
    }

    @Override
    public boolean isConstantResult() {
        return this.isReturnsConstantResult;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.getChildNodes().isEmpty()) {
            buffer.append('(');
            buffer.append(this.getChildNodes().get(0).toExpressionString());
            buffer.append(")");
        }
        ExprNodeUtility.toExpressionString(this.chainSpec, buffer, !this.getChildNodes().isEmpty());
        return buffer.toString();
    }

    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprDotNode)) {
            return false;
        }
        ExprDotNode other = (ExprDotNode)node;
        if (other.chainSpec.size() != this.chainSpec.size()) {
            return false;
        }
        for (int i = 0; i < this.chainSpec.size(); ++i) {
            if (this.chainSpec.get(i).equals(other.chainSpec.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return ExprNodeUtility.collectChainParameters(this.chainSpec);
    }

    public static Pair<ExprEvaluatorEnumeration, ExprDotEvalTypeInfo> getEnumerationSource(ExprNode inputExpression, StreamTypeService streamTypeService, EventAdapterService eventAdapterService, String statementId, boolean hasEnumerationMethod) throws ExprValidationException {
        ExprEvaluator rootNodeEvaluator = inputExpression.getExprEvaluator();
        ExprEvaluatorEnumeration rootLambdaEvaluator = null;
        ExprDotEvalTypeInfo info = null;
        if (rootNodeEvaluator instanceof ExprEvaluatorEnumeration) {
            rootLambdaEvaluator = (ExprEvaluatorEnumeration)((Object)rootNodeEvaluator);
            if (rootLambdaEvaluator.getEventTypeCollection(eventAdapterService) != null) {
                info = ExprDotEvalTypeInfo.eventColl(rootLambdaEvaluator.getEventTypeCollection(eventAdapterService));
            } else if (rootLambdaEvaluator.getEventTypeSingle(eventAdapterService, statementId) != null) {
                info = ExprDotEvalTypeInfo.event(rootLambdaEvaluator.getEventTypeSingle(eventAdapterService, statementId));
            } else if (rootLambdaEvaluator.getComponentTypeCollection() != null) {
                info = ExprDotEvalTypeInfo.componentColl(rootLambdaEvaluator.getComponentTypeCollection());
            }
        } else if (inputExpression instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)inputExpression;
            int streamId = identNode.getStreamId();
            EventType streamType = streamTypeService.getEventTypes()[streamId];
            return ExprDotNode.getPropertyEnumerationSource(identNode.getResolvedPropertyName(), streamId, streamType, hasEnumerationMethod);
        }
        return new Pair<ExprEvaluatorEnumeration, Object>(rootLambdaEvaluator, info);
    }

    public static Pair<ExprEvaluatorEnumeration, ExprDotEvalTypeInfo> getPropertyEnumerationSource(String propertyName, int streamId, EventType streamType, boolean hasEnumerationMethod) {
        EventPropertyGetter getter = streamType.getGetter(propertyName);
        FragmentEventType fragmentEventType = streamType.getFragmentType(propertyName);
        Class propertyType = streamType.getPropertyType(propertyName);
        ExprDotEvalTypeInfo typeInfo = ExprDotEvalTypeInfo.scalarOrUnderlying(propertyType);
        if (!hasEnumerationMethod) {
            return new Pair<Object, ExprDotEvalTypeInfo>(null, typeInfo);
        }
        ExprEvaluatorEnumeration enumEvaluator = null;
        if (getter != null && fragmentEventType != null && fragmentEventType.isIndexed()) {
            enumEvaluator = new PropertyExprEvaluatorEventCollection(propertyName, streamId, fragmentEventType.getFragmentType(), getter);
            typeInfo = ExprDotEvalTypeInfo.eventColl(fragmentEventType.getFragmentType());
        } else {
            EventPropertyDescriptor desc = streamType.getPropertyDescriptor(propertyName);
            if (desc != null && desc.isIndexed() && !desc.isRequiresIndex() && desc.getPropertyComponentType() != null) {
                if (JavaClassHelper.isImplementsInterface(propertyType, Collection.class)) {
                    enumEvaluator = new PropertyExprEvaluatorScalarCollection(propertyName, streamId, getter, desc.getPropertyComponentType());
                } else if (JavaClassHelper.isImplementsInterface(propertyType, Iterable.class)) {
                    enumEvaluator = new PropertyExprEvaluatorScalarIterable(propertyName, streamId, getter, desc.getPropertyComponentType());
                } else if (propertyType.isArray()) {
                    enumEvaluator = new PropertyExprEvaluatorScalarArray(propertyName, streamId, getter, desc.getPropertyComponentType());
                } else {
                    throw new IllegalStateException("Property indicated indexed-type but failed to find proper collection adapter for use with enumeration methods");
                }
                typeInfo = ExprDotEvalTypeInfo.componentColl(desc.getPropertyComponentType());
            }
        }
        return new Pair<Object, ExprDotEvalTypeInfo>(enumEvaluator, typeInfo);
    }
}

