/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEqualsNode;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.util.Map;

public class ExprEqualsNodeImpl
extends ExprNodeBase
implements ExprEqualsNode {
    private final boolean isNotEquals;
    private final boolean isIs;
    private transient ExprEvaluator evaluator;
    private static final long serialVersionUID = 5504809379222369952L;

    public ExprEqualsNodeImpl(boolean isNotEquals, boolean isIs) {
        this.isNotEquals = isNotEquals;
        this.isIs = isIs;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    @Override
    public boolean isNotEquals() {
        return this.isNotEquals;
    }

    @Override
    public boolean isIs() {
        return this.isIs;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class coercionType;
        if (this.getChildNodes().size() != 2) {
            throw new IllegalStateException("Equals node does not have exactly 2 child nodes");
        }
        ExprEvaluator[] evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class typeOne = JavaClassHelper.getBoxedType(evaluators[0].getType());
        Class typeTwo = JavaClassHelper.getBoxedType(evaluators[1].getType());
        if (typeOne == null || typeTwo == null) {
            this.evaluator = this.getEvaluator(evaluators[0], evaluators[1]);
            return;
        }
        if (typeOne.equals(typeTwo) || typeOne.isAssignableFrom(typeTwo)) {
            this.evaluator = this.getEvaluator(evaluators[0], evaluators[1]);
            return;
        }
        try {
            coercionType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to '" + typeOne.getSimpleName() + "' is not allowed");
        }
        if (coercionType == JavaClassHelper.getBoxedType(typeOne) && coercionType == JavaClassHelper.getBoxedType(typeTwo)) {
            this.evaluator = this.getEvaluator(evaluators[0], evaluators[1]);
        } else {
            if (!JavaClassHelper.isNumeric(coercionType)) {
                throw new ExprValidationException("Cannot convert datatype '" + coercionType.getName() + "' to a numeric value");
            }
            SimpleNumberCoercer numberCoercerLHS = SimpleNumberCoercerFactory.getCoercer(typeOne, coercionType);
            SimpleNumberCoercer numberCoercerRHS = SimpleNumberCoercerFactory.getCoercer(typeTwo, coercionType);
            this.evaluator = new ExprEqualsEvaluatorCoercing(this.isIs, this.isNotEquals, evaluators[0], evaluators[1], numberCoercerLHS, numberCoercerRHS);
        }
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(" = ");
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprEqualsNodeImpl)) {
            return false;
        }
        ExprEqualsNodeImpl other = (ExprEqualsNodeImpl)node;
        return other.isNotEquals == this.isNotEquals;
    }

    private ExprEvaluator getEvaluator(ExprEvaluator lhs, ExprEvaluator rhs) {
        if (this.isIs) {
            return new ExprEqualsEvaluatorIs(this.isNotEquals, lhs, rhs);
        }
        return new ExprEqualsEvaluatorEquals(this.isNotEquals, lhs, rhs);
    }

    public static class ExprEqualsEvaluatorIs
    implements ExprEvaluator {
        private transient boolean isNotEquals;
        private transient ExprEvaluator lhs;
        private transient ExprEvaluator rhs;

        public ExprEqualsEvaluatorIs(boolean notEquals, ExprEvaluator lhs, ExprEvaluator rhs) {
            this.isNotEquals = notEquals;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Object leftResult = this.lhs.evaluate(eventsPerStream, isNewData, context);
            Object rightResult = this.rhs.evaluate(eventsPerStream, isNewData, context);
            if (leftResult == null) {
                return rightResult == null ^ this.isNotEquals;
            }
            return (rightResult != null && leftResult.equals(rightResult)) ^ this.isNotEquals;
        }

        @Override
        public Class getType() {
            return Boolean.class;
        }

        @Override
        public Map<String, Object> getEventType() throws ExprValidationException {
            return null;
        }
    }

    public static class ExprEqualsEvaluatorEquals
    implements ExprEvaluator {
        private transient boolean isNotEquals;
        private transient ExprEvaluator lhs;
        private transient ExprEvaluator rhs;

        public ExprEqualsEvaluatorEquals(boolean notEquals, ExprEvaluator lhs, ExprEvaluator rhs) {
            this.isNotEquals = notEquals;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Object leftResult = this.lhs.evaluate(eventsPerStream, isNewData, context);
            Object rightResult = this.rhs.evaluate(eventsPerStream, isNewData, context);
            if (leftResult == null || rightResult == null) {
                return null;
            }
            return leftResult.equals(rightResult) ^ this.isNotEquals;
        }

        @Override
        public Class getType() {
            return Boolean.class;
        }

        @Override
        public Map<String, Object> getEventType() throws ExprValidationException {
            return null;
        }
    }

    public static class ExprEqualsEvaluatorCoercing
    implements ExprEvaluator {
        private transient boolean isIs;
        private transient boolean isNotEquals;
        private transient ExprEvaluator lhs;
        private transient ExprEvaluator rhs;
        private transient SimpleNumberCoercer numberCoercerLHS;
        private transient SimpleNumberCoercer numberCoercerRHS;

        public ExprEqualsEvaluatorCoercing(boolean isIs, boolean isNotEquals, ExprEvaluator lhs, ExprEvaluator rhs, SimpleNumberCoercer numberCoercerLHS, SimpleNumberCoercer numberCoercerRHS) {
            this.isIs = isIs;
            this.isNotEquals = isNotEquals;
            this.lhs = lhs;
            this.rhs = rhs;
            this.numberCoercerLHS = numberCoercerLHS;
            this.numberCoercerRHS = numberCoercerRHS;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Object leftResult = this.lhs.evaluate(eventsPerStream, isNewData, context);
            Object rightResult = this.rhs.evaluate(eventsPerStream, isNewData, context);
            if (!this.isIs) {
                if (leftResult == null || rightResult == null) {
                    return null;
                }
            } else {
                if (leftResult == null) {
                    return rightResult == null;
                }
                if (rightResult == null) {
                    return false;
                }
            }
            Number left = this.numberCoercerLHS.coerceBoxed((Number)leftResult);
            Number right = this.numberCoercerRHS.coerceBoxed((Number)rightResult);
            return left.equals(right) ^ this.isNotEquals;
        }

        @Override
        public Class getType() {
            return Boolean.class;
        }

        @Override
        public Map<String, Object> getEventType() throws ExprValidationException {
            return null;
        }
    }
}

