/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorEnumeration;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprEvaluatorProxy
implements InvocationHandler {
    private static final Log auditLog = LogFactory.getLog((String)"com.espertech.esper.audit");
    private static Method targetEvaluate = JavaClassHelper.getMethodByName(ExprEvaluator.class, "evaluate");
    private static Method targetEvaluateCollEvents = JavaClassHelper.getMethodByName(ExprEvaluatorEnumeration.class, "evaluateGetROCollectionEvents");
    private static Method targetEvaluateCollScalar = JavaClassHelper.getMethodByName(ExprEvaluatorEnumeration.class, "evaluateGetROCollectionScalar");
    private static Method targetEvaluateBean = JavaClassHelper.getMethodByName(ExprEvaluatorEnumeration.class, "evaluateGetEventBean");
    private final String statementName;
    private final String expressionToString;
    private final ExprEvaluator evaluator;

    public static Object newInstance(String statementName, String expressionToString, ExprEvaluator evaluator) {
        return Proxy.newProxyInstance(evaluator.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(evaluator.getClass()), (InvocationHandler)new ExprEvaluatorProxy(statementName, expressionToString, evaluator));
    }

    public ExprEvaluatorProxy(String statementName, String expressionToString, ExprEvaluator evaluator) {
        this.statementName = statementName;
        this.expressionToString = expressionToString;
        this.evaluator = evaluator;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.equals(targetEvaluate)) {
            Object result = m.invoke((Object)this.evaluator, args);
            if (auditLog.isInfoEnabled()) {
                auditLog.info((Object)("Statement " + this.statementName + " expression " + this.expressionToString + " result " + result));
            }
            return result;
        }
        if (m.equals(targetEvaluateCollEvents)) {
            Object result = m.invoke((Object)this.evaluator, args);
            if (auditLog.isInfoEnabled()) {
                Collection resultBeans = (Collection)result;
                String out = "null";
                if (resultBeans != null) {
                    if (resultBeans.isEmpty()) {
                        out = "{}";
                    } else {
                        StringWriter buf = new StringWriter();
                        int count = 0;
                        for (EventBean event : resultBeans) {
                            buf.append(" Event ");
                            buf.append(Integer.toString(count++));
                            buf.append(":");
                            EventBeanUtility.appendEvent(buf, event);
                        }
                        out = buf.toString();
                    }
                }
                auditLog.info((Object)("Statement " + this.statementName + " expression " + this.expressionToString + " result " + out));
            }
            return result;
        }
        if (m.equals(targetEvaluateCollScalar)) {
            Object result = m.invoke((Object)this.evaluator, args);
            if (auditLog.isInfoEnabled()) {
                auditLog.info((Object)("Statement " + this.statementName + " expression " + this.expressionToString + " result " + result));
            }
            return result;
        }
        if (m.equals(targetEvaluateBean)) {
            Object result = m.invoke((Object)this.evaluator, args);
            if (auditLog.isInfoEnabled()) {
                String out = "null";
                if (result != null) {
                    StringWriter buf = new StringWriter();
                    EventBeanUtility.appendEvent(buf, (EventBean)result);
                    out = buf.toString();
                }
                auditLog.info((Object)("Statement " + this.statementName + " expression " + this.expressionToString + " result " + out));
            }
            return result;
        }
        return m.invoke((Object)this.evaluator, args);
    }
}

