/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNodeEvaluator;
import com.espertech.esper.epl.expression.ExprValidationException;
import java.util.Map;

public class ExprIdentNodeEvaluatorImpl
implements ExprIdentNodeEvaluator {
    private final int streamNum;
    private final EventPropertyGetter propertyGetter;
    private final Class propertyType;

    public ExprIdentNodeEvaluatorImpl(int streamNum, EventPropertyGetter propertyGetter, Class propertyType) {
        this.streamNum = streamNum;
        this.propertyGetter = propertyGetter;
        this.propertyType = propertyType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        return this.propertyGetter.get(event);
    }

    @Override
    public Class getType() {
        return this.propertyType;
    }

    @Override
    public Map<String, Object> getEventType() throws ExprValidationException {
        return null;
    }

    @Override
    public boolean evaluatePropertyExists(EventBean[] eventsPerStream, boolean isNewData) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return false;
        }
        return this.propertyGetter.isExistsProperty(event);
    }

    @Override
    public int getStreamNum() {
        return this.streamNum;
    }
}

