/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypesException;
import com.espertech.esper.epl.expression.ExprValidationPropertyException;

public class ExprIdentNodeUtil {
    protected static Pair<PropertyResolutionDescriptor, String> getTypeFromStream(StreamTypeService streamTypeService, String unresolvedPropertyName, String streamOrPropertyName) throws ExprValidationPropertyException {
        if (streamOrPropertyName == null) {
            PropertyResolutionDescriptor propertyInfo;
            try {
                propertyInfo = streamTypeService.resolveByPropertyName(unresolvedPropertyName);
            }
            catch (StreamTypesException ex) {
                String suggestion = ExprIdentNodeUtil.getSuggestion(ex);
                if (suggestion != null) {
                    throw new ExprValidationPropertyException(ex.getMessage() + suggestion);
                }
                throw new ExprValidationPropertyException(ex.getMessage());
            }
            catch (PropertyAccessException ex) {
                throw new ExprValidationPropertyException(ex.getMessage());
            }
            return new Pair<PropertyResolutionDescriptor, String>(propertyInfo, propertyInfo.getStreamName());
        }
        try {
            PropertyResolutionDescriptor propertyInfo = streamTypeService.resolveByStreamAndPropName(streamOrPropertyName, unresolvedPropertyName);
            return new Pair<PropertyResolutionDescriptor, String>(propertyInfo, streamOrPropertyName);
        }
        catch (StreamTypesException ex) {
            StreamTypesException typeExceptionOne = ex;
            String propertyNameCandidate = streamOrPropertyName + '.' + unresolvedPropertyName;
            try {
                PropertyResolutionDescriptor propertyInfo = streamTypeService.resolveByPropertyName(propertyNameCandidate);
                return new Pair<PropertyResolutionDescriptor, Object>(propertyInfo, null);
            }
            catch (StreamTypesException ex2) {
                StreamTypesException typeExceptionTwo = ex2;
                String suggestionOne = ExprIdentNodeUtil.getSuggestion(typeExceptionOne);
                String suggestionTwo = ExprIdentNodeUtil.getSuggestion(typeExceptionTwo);
                if (suggestionOne != null) {
                    throw new ExprValidationPropertyException(typeExceptionOne.getMessage() + suggestionOne);
                }
                if (suggestionTwo != null) {
                    throw new ExprValidationPropertyException(typeExceptionTwo.getMessage() + suggestionTwo);
                }
                throw new ExprValidationPropertyException("Failed to resolve property '" + propertyNameCandidate + "' to a stream or nested property in a stream");
            }
        }
    }

    private static String getSuggestion(StreamTypesException ex) {
        if (ex == null) {
            return null;
        }
        if (ex.getOptionalSuggestion() == null) {
            return null;
        }
        if (ex.getOptionalSuggestion().getFirst() > 3) {
            return null;
        }
        return " (did you mean '" + ex.getOptionalSuggestion().getSecond() + "'?)";
    }
}

