/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNewNode
extends ExprNodeBase
implements ExprEvaluator {
    private static final long serialVersionUID = -210293632565665600L;
    private final String[] columnNames;
    private transient Map<String, Object> eventType;
    private transient ExprEvaluator[] evaluators;
    private boolean isAllConstants;
    private static final Log log = LogFactory.getLog(ExprNewNode.class);

    public ExprNewNode(String[] columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.eventType = new HashMap<String, Object>();
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        for (int i = 0; i < this.columnNames.length; ++i) {
            boolean bl = this.isAllConstants = this.isAllConstants && this.getChildNodes().get(i).isConstantResult();
            if (this.eventType.containsKey(this.columnNames[i])) {
                throw new ExprValidationException("Failed to validate new-keyword property names, property '" + this.columnNames[i] + "' has already been declared");
            }
            Map<String, Object> eventTypeResult = this.evaluators[i].getEventType();
            Class classResult = JavaClassHelper.getBoxedType(this.evaluators[i].getType());
            if (eventTypeResult != null) {
                this.eventType.put(this.columnNames[i], eventTypeResult);
                continue;
            }
            this.eventType.put(this.columnNames[i], classResult);
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public boolean isConstantResult() {
        return this.isAllConstants;
    }

    @Override
    public Class getType() {
        return Map.class;
    }

    @Override
    public Map<String, Object> getEventType() {
        return this.eventType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (int i = 0; i < this.evaluators.length; ++i) {
            props.put(this.columnNames[i], this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext));
        }
        return props;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprNewNode)) {
            return false;
        }
        ExprNewNode other = (ExprNewNode)node;
        return Arrays.deepEquals(other.columnNames, this.columnNames);
    }

    @Override
    public String toExpressionString() {
        StringWriter writer = new StringWriter();
        writer.write("new { ");
        String delimiter = "";
        for (int i = 0; i < this.getChildNodes().size(); ++i) {
            ExprIdentNode prop;
            writer.append(delimiter);
            writer.append(this.columnNames[i]);
            ExprNode expr = this.getChildNodes().get(i);
            boolean outputexpr = true;
            if (expr instanceof ExprIdentNode && (prop = (ExprIdentNode)expr).getResolvedPropertyName().equals(this.columnNames[i])) {
                outputexpr = false;
            }
            if (outputexpr) {
                writer.append(" = ");
                writer.append(expr.toExpressionString());
            }
            delimiter = ", ";
        }
        writer.write(" }");
        return writer.toString();
    }
}

