/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeVisitor;
import java.util.LinkedList;
import java.util.List;

public class ExprNodeIdentifierVisitor
implements ExprNodeVisitor {
    private final List<Pair<Integer, String>> exprProperties;
    private final boolean isVisitAggregateNodes;

    public ExprNodeIdentifierVisitor(boolean visitAggregateNodes) {
        this.isVisitAggregateNodes = visitAggregateNodes;
        this.exprProperties = new LinkedList<Pair<Integer, String>>();
    }

    @Override
    public boolean isVisit(ExprNode exprNode) {
        if (exprNode instanceof ExprLambdaGoesNode) {
            return false;
        }
        if (this.isVisitAggregateNodes) {
            return true;
        }
        return !(exprNode instanceof ExprAggregateNode);
    }

    public List<Pair<Integer, String>> getExprProperties() {
        return this.exprProperties;
    }

    @Override
    public void visit(ExprNode exprNode) {
        if (!(exprNode instanceof ExprIdentNode)) {
            return;
        }
        ExprIdentNode identNode = (ExprIdentNode)exprNode;
        int streamId = identNode.getStreamId();
        String propertyName = identNode.getResolvedPropertyName();
        this.exprProperties.add(new Pair<Integer, String>(streamId, propertyName));
    }
}

