/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.ContextPropertyRegistry;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportSingleRowDesc;
import com.espertech.esper.epl.core.EngineImportUndefinedException;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.ExprChainedSpec;
import com.espertech.esper.epl.expression.ExprConstantNode;
import com.espertech.esper.epl.expression.ExprConstantNodeImpl;
import com.espertech.esper.epl.expression.ExprDotNode;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprIdentNodeImpl;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.epl.expression.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.expression.ExprNodeProxy;
import com.espertech.esper.epl.expression.ExprNodeSubselectVisitor;
import com.espertech.esper.epl.expression.ExprNodeViewResourceVisitor;
import com.espertech.esper.epl.expression.ExprNodeVisitor;
import com.espertech.esper.epl.expression.ExprNodeVisitorWithParent;
import com.espertech.esper.epl.expression.ExprPlugInAggFunctionNode;
import com.espertech.esper.epl.expression.ExprPlugInSingleRowNode;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNodeImpl;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.schedule.ScheduleParameterException;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.schedule.ScheduleSpecUtil;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNodeUtility {
    private static final Log log = LogFactory.getLog(ExprNodeUtility.class);

    public static List<Pair<Integer, String>> getExpressionProperties(ExprNode exprNode, boolean visitAggregateNodes) {
        ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(visitAggregateNodes);
        exprNode.accept(visitor);
        return visitor.getExprProperties();
    }

    public static ExprNode getValidatedSubtree(ExprNode exprNode, ExprValidationContext validationContext) throws ExprValidationException {
        if (exprNode instanceof ExprLambdaGoesNode) {
            return exprNode;
        }
        return ExprNodeUtility.getValidatedSubtreeInternal(exprNode, validationContext, true);
    }

    private static ExprNode getValidatedSubtreeInternal(ExprNode exprNode, ExprValidationContext validationContext, boolean isTopLevel) throws ExprValidationException {
        ExprNode result = exprNode;
        if (exprNode instanceof ExprLambdaGoesNode) {
            return exprNode;
        }
        for (int i = 0; i < exprNode.getChildNodes().size(); ++i) {
            ExprNode childNode = exprNode.getChildNodes().get(i);
            if (childNode instanceof ExprLambdaGoesNode) continue;
            ExprNode childNodeValidated = ExprNodeUtility.getValidatedSubtreeInternal(childNode, validationContext, false);
            exprNode.getChildNodes().set(i, childNodeValidated);
        }
        try {
            exprNode.validate(validationContext);
        }
        catch (ExprValidationException e) {
            if (exprNode instanceof ExprIdentNode) {
                ExprIdentNode identNode = (ExprIdentNode)exprNode;
                try {
                    result = ExprNodeUtility.resolveStaticMethodOrField(identNode, e, validationContext);
                }
                catch (ExprValidationException ex) {
                    e = ex;
                    result = ExprNodeUtility.resolveAsStreamName(identNode, e, validationContext);
                }
            }
            throw e;
        }
        if (isTopLevel ? validationContext.isExpressionAudit() : validationContext.isExpressionNestedAudit() && !(result instanceof ExprIdentNode) && !(result instanceof ExprConstantNode)) {
            return (ExprNode)ExprNodeProxy.newInstance(validationContext.getStatementName(), result);
        }
        return result;
    }

    private static ExprNode resolveAsStreamName(ExprIdentNode identNode, ExprValidationException existingException, ExprValidationContext validationContext) throws ExprValidationException {
        ExprStreamUnderlyingNodeImpl exprStream = new ExprStreamUnderlyingNodeImpl(identNode.getUnresolvedPropertyName(), false);
        try {
            exprStream.validate(validationContext);
        }
        catch (ExprValidationException ex) {
            throw existingException;
        }
        return exprStream;
    }

    private static ExprNode resolveStaticMethodOrField(ExprIdentNode identNode, ExprValidationException propertyException, ExprValidationContext validationContext) throws ExprValidationException {
        MappedPropertyParseResult parse;
        StringBuffer mappedProperty = new StringBuffer(identNode.getUnresolvedPropertyName());
        if (identNode.getStreamOrPropertyName() != null) {
            mappedProperty.insert(0, identNode.getStreamOrPropertyName() + '.');
        }
        if ((parse = ExprNodeUtility.parseMappedProperty(mappedProperty.toString())) == null) {
            ExprConstantNode constNode = ExprNodeUtility.resolveIdentAsEnumConst(mappedProperty.toString(), validationContext.getMethodResolutionService());
            if (constNode == null) {
                throw propertyException;
            }
            return constNode;
        }
        if (parse.getClassName() != null) {
            List<ExprNode> parameters = Collections.singletonList(new ExprConstantNodeImpl(parse.getArgString()));
            ArrayList<ExprChainedSpec> chain = new ArrayList<ExprChainedSpec>();
            chain.add(new ExprChainedSpec(parse.getClassName(), Collections.<ExprNode>emptyList(), false));
            chain.add(new ExprChainedSpec(parse.getMethodName(), parameters, false));
            ExprDotNode result = new ExprDotNode(chain, validationContext.getMethodResolutionService().isDuckType(), validationContext.getMethodResolutionService().isUdfCache());
            try {
                result.validate(validationContext);
            }
            catch (ExprValidationException e) {
                throw new ExprValidationException("Failed to resolve enumeration method, date-time method or mapped property '" + mappedProperty + "': " + e.getMessage());
            }
            return result;
        }
        String functionName = parse.getMethodName();
        try {
            Pair<Class, EngineImportSingleRowDesc> classMethodPair = validationContext.getMethodResolutionService().resolveSingleRow(functionName);
            List<ExprNode> params = Collections.singletonList(new ExprConstantNodeImpl(parse.getArgString()));
            List<ExprChainedSpec> chain = Collections.singletonList(new ExprChainedSpec(classMethodPair.getSecond().getMethodName(), params, false));
            ExprPlugInSingleRowNode result = new ExprPlugInSingleRowNode(functionName, classMethodPair.getFirst(), chain, classMethodPair.getSecond().getValueCache());
            try {
                result.validate(validationContext);
            }
            catch (RuntimeException e) {
                throw new ExprValidationException("Plug-in aggregation function '" + parse.getMethodName() + "' failed validation: " + e.getMessage());
            }
            return result;
        }
        catch (EngineImportUndefinedException e) {
        }
        catch (EngineImportException e) {
            throw new IllegalStateException("Error resolving single-row function: " + e.getMessage(), e);
        }
        try {
            AggregationSupport aggregation = validationContext.getMethodResolutionService().resolveAggregation(parse.getMethodName());
            ExprPlugInAggFunctionNode result = new ExprPlugInAggFunctionNode(false, aggregation, parse.getMethodName());
            result.addChildNode(new ExprConstantNodeImpl(parse.getArgString()));
            try {
                result.validate(validationContext);
            }
            catch (RuntimeException e) {
                throw new ExprValidationException("Plug-in aggregation function '" + parse.getMethodName() + "' failed validation: " + e.getMessage());
            }
            return result;
        }
        catch (EngineImportUndefinedException e) {
        }
        catch (EngineImportException e) {
            throw new IllegalStateException("Error resolving aggregation: " + e.getMessage(), e);
        }
        throw propertyException;
    }

    private static ExprConstantNode resolveIdentAsEnumConst(String constant, MethodResolutionService methodResolutionService) throws ExprValidationException {
        Object enumValue = JavaClassHelper.resolveIdentAsEnumConst(constant, methodResolutionService, null);
        if (enumValue != null) {
            return new ExprConstantNodeImpl(enumValue);
        }
        return null;
    }

    protected static MappedPropertyParseResult parseMappedProperty(String property) {
        int indexFirstDoubleQuote = property.indexOf("\"");
        int indexFirstSingleQuote = property.indexOf("'");
        if (indexFirstSingleQuote == -1 && indexFirstDoubleQuote == -1) {
            return null;
        }
        int startArg = indexFirstSingleQuote != -1 && indexFirstDoubleQuote != -1 ? (indexFirstSingleQuote < indexFirstDoubleQuote ? indexFirstSingleQuote : indexFirstDoubleQuote) : (indexFirstSingleQuote != -1 ? indexFirstSingleQuote : indexFirstDoubleQuote);
        int indexLastDoubleQuote = property.lastIndexOf("\"");
        int indexLastSingleQuote = property.lastIndexOf("'");
        if (indexLastSingleQuote == -1 && indexLastDoubleQuote == -1) {
            return null;
        }
        int endArg = indexLastSingleQuote != -1 && indexLastDoubleQuote != -1 ? (indexLastSingleQuote > indexLastDoubleQuote ? indexLastSingleQuote : indexLastDoubleQuote) : (indexLastSingleQuote != -1 ? indexLastSingleQuote : indexLastDoubleQuote);
        String argument = property.substring(startArg + 1, endArg);
        String[] splitDots = property.split("[\\.]");
        if (splitDots.length == 0) {
            return null;
        }
        int indexMethod = -1;
        for (int i = 0; i < splitDots.length; ++i) {
            if (!splitDots[i].contains("(")) continue;
            indexMethod = i;
            break;
        }
        if (indexMethod == -1) {
            return null;
        }
        String method = splitDots[indexMethod];
        int indexParan = method.indexOf("(");
        if ((method = method.substring(0, indexParan)).length() == 0) {
            return null;
        }
        if (splitDots.length == 1) {
            return new MappedPropertyParseResult(null, method, argument);
        }
        StringBuffer clazz = new StringBuffer();
        for (int i = 0; i < indexMethod; ++i) {
            if (i > 0) {
                clazz.append('.');
            }
            clazz.append(splitDots[i]);
        }
        return new MappedPropertyParseResult(clazz.toString(), method, argument);
    }

    public static boolean isAllConstants(List<ExprNode> parameters) {
        for (ExprNode node : parameters) {
            if (node.isConstantResult()) continue;
            return false;
        }
        return true;
    }

    public static ExprIdentNode getExprIdentNode(EventType[] typesPerStream, int streamId, String property) {
        return new ExprIdentNodeImpl(typesPerStream[streamId], property, streamId);
    }

    public static void acceptChain(ExprNodeVisitor visitor, List<ExprChainedSpec> chainSpec) {
        for (ExprChainedSpec chain : chainSpec) {
            for (ExprNode param : chain.getParameters()) {
                param.accept(visitor);
            }
        }
    }

    public static void acceptChain(ExprNodeVisitorWithParent visitor, List<ExprChainedSpec> chainSpec) {
        for (ExprChainedSpec chain : chainSpec) {
            for (ExprNode param : chain.getParameters()) {
                param.accept(visitor);
            }
        }
    }

    public static void acceptChain(ExprNodeVisitorWithParent visitor, List<ExprChainedSpec> chainSpec, ExprNode parent) {
        for (ExprChainedSpec chain : chainSpec) {
            for (ExprNode param : chain.getParameters()) {
                param.acceptChildnodes(visitor, parent);
            }
        }
    }

    public static final void replaceChildNode(ExprNode parentNode, ExprNode nodeToReplace, ExprNode newNode) {
        int index = parentNode.getChildNodes().indexOf(nodeToReplace);
        if (index == -1) {
            parentNode.replaceUnlistedChildNode(nodeToReplace, newNode);
        } else {
            parentNode.getChildNodes().set(index, newNode);
        }
    }

    public static void replaceChainChildNode(ExprNode nodeToReplace, ExprNode newNode, List<ExprChainedSpec> chainSpec) {
        for (ExprChainedSpec chained : chainSpec) {
            int index = chained.getParameters().indexOf(nodeToReplace);
            if (index == -1) continue;
            chained.getParameters().set(index, newNode);
        }
    }

    public static Set<Pair<Integer, String>> getNonAggregatedProps(EventType[] types, List<ExprNode> exprNodes, ContextPropertyRegistry contextPropertyRegistry) {
        HashSet<Pair<Integer, String>> nonAggProps = new HashSet<Pair<Integer, String>>();
        for (ExprNode node : exprNodes) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(false);
            node.accept(visitor);
            List<Pair<Integer, String>> propertiesNodes = visitor.getExprProperties();
            for (Pair<Integer, String> pair : propertiesNodes) {
                EventType originType;
                EventType eventType = originType = types.length > pair.getFirst() ? types[pair.getFirst()] : null;
                if (originType != null && contextPropertyRegistry != null && contextPropertyRegistry.isPartitionProperty(originType, pair.getSecond())) continue;
                nonAggProps.add(pair);
            }
        }
        return nonAggProps;
    }

    public static void addNonAggregatedProps(ExprNode exprNode, Set<Pair<Integer, String>> set) {
        ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(false);
        exprNode.accept(visitor);
        set.addAll(visitor.getExprProperties());
    }

    public static Set<Pair<Integer, String>> getAggregatedProperties(List<ExprAggregateNode> aggregateNodes) {
        HashSet<Pair<Integer, String>> propertiesAggregated = new HashSet<Pair<Integer, String>>();
        for (ExprAggregateNode selectAggExprNode : aggregateNodes) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            selectAggExprNode.accept(visitor);
            List<Pair<Integer, String>> properties = visitor.getExprProperties();
            propertiesAggregated.addAll(properties);
        }
        return propertiesAggregated;
    }

    public static ExprEvaluator[] getEvaluators(ExprNode[] exprNodes) {
        if (exprNodes == null) {
            return null;
        }
        ExprEvaluator[] eval = new ExprEvaluator[exprNodes.length];
        for (int i = 0; i < exprNodes.length; ++i) {
            ExprNode node = exprNodes[i];
            if (node == null) continue;
            eval[i] = node.getExprEvaluator();
        }
        return eval;
    }

    public static ExprEvaluator[] getEvaluators(List<ExprNode> childNodes) {
        ExprEvaluator[] eval = new ExprEvaluator[childNodes.size()];
        for (int i = 0; i < childNodes.size(); ++i) {
            eval[i] = childNodes.get(i).getExprEvaluator();
        }
        return eval;
    }

    public static Set<Integer> getIdentStreamNumbers(ExprNode child) {
        HashSet<Integer> streams = new HashSet<Integer>();
        ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
        child.accept(visitor);
        for (ExprIdentNode node : visitor.getExprProperties()) {
            streams.add(node.getStreamId());
        }
        return streams;
    }

    public static boolean hasRemoveStream(ExprNode child, StreamTypeService streamTypeService) {
        boolean[] isIStreamOnly = streamTypeService.getIStreamOnly();
        boolean isAllIStream = true;
        boolean isAllIRStream = true;
        for (boolean anIsIStreamOnly : isIStreamOnly) {
            if (!anIsIStreamOnly) {
                isAllIStream = false;
                continue;
            }
            isAllIRStream = false;
        }
        boolean hasDataWindows = true;
        if (isAllIStream) {
            hasDataWindows = false;
        } else if (!isAllIRStream && streamTypeService.getEventTypes().length <= 1) {
            hasDataWindows = false;
            ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
            child.accept(visitor);
            for (ExprIdentNode node : visitor.getExprProperties()) {
                if (isIStreamOnly[node.getStreamId()]) continue;
                hasDataWindows = true;
                break;
            }
        }
        return hasDataWindows;
    }

    public static EventBean[] applyFilterExpression(ExprEvaluator filter, EventBean streamZeroEvent, EventBean[] streamOneEvents, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] eventsPerStream = new EventBean[2];
        eventsPerStream[0] = streamZeroEvent;
        EventBean[] filtered = new EventBean[streamOneEvents.length];
        int countPass = 0;
        EventBean[] arr$ = streamOneEvents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EventBean eventBean;
            eventsPerStream[1] = eventBean = arr$[i$];
            Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (result == null || !result.booleanValue()) continue;
            filtered[countPass] = eventBean;
            ++countPass;
        }
        if (countPass == streamOneEvents.length) {
            return streamOneEvents;
        }
        return EventBeanUtility.resizeArray(filtered, countPass);
    }

    public static boolean applyFilterExpression(ExprEvaluator filter, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, exprEvaluatorContext);
        return result != null && result != false;
    }

    public static boolean deepEquals(ExprNode nodeOne, ExprNode nodeTwo) {
        if (nodeOne.getChildNodes().size() != nodeTwo.getChildNodes().size()) {
            return false;
        }
        if (!nodeOne.equalsNode(nodeTwo)) {
            return false;
        }
        for (int i = 0; i < nodeOne.getChildNodes().size(); ++i) {
            ExprNode childNodeTwo;
            ExprNode childNodeOne = nodeOne.getChildNodes().get(i);
            if (ExprNodeUtility.deepEquals(childNodeOne, childNodeTwo = nodeTwo.getChildNodes().get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(ExprNode[] one, ExprNode[] two) {
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (ExprNodeUtility.deepEquals(one[i], two[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(List<ExprNode> one, List<ExprNode> two) {
        if (one.size() != two.size()) {
            return false;
        }
        for (int i = 0; i < one.size(); ++i) {
            if (ExprNodeUtility.deepEquals(one.get(i), two.get(i))) continue;
            return false;
        }
        return true;
    }

    public static String isMinimalExpression(ExprNode expression) {
        ExprNodeSubselectVisitor subselectVisitor = new ExprNodeSubselectVisitor();
        expression.accept(subselectVisitor);
        if (subselectVisitor.getSubselects().size() > 0) {
            return "a subselect";
        }
        ExprNodeViewResourceVisitor viewResourceVisitor = new ExprNodeViewResourceVisitor();
        expression.accept(viewResourceVisitor);
        if (viewResourceVisitor.getExprNodes().size() > 0) {
            return "a function that requires view resources (prior, prev)";
        }
        LinkedList<ExprAggregateNode> aggregateNodes = new LinkedList<ExprAggregateNode>();
        ExprAggregateNodeUtil.getAggregatesBottomUp(expression, aggregateNodes);
        if (!aggregateNodes.isEmpty()) {
            return "an aggregation function";
        }
        return null;
    }

    protected static void toExpressionString(List<ExprChainedSpec> chainSpec, StringBuilder buffer, boolean prefixDot) {
        String delimiterOuter = "";
        if (prefixDot) {
            delimiterOuter = ".";
        }
        boolean isFirst = true;
        for (ExprChainedSpec element : chainSpec) {
            buffer.append(delimiterOuter);
            buffer.append(element.getName());
            if (!isFirst || prefixDot || !element.getParameters().isEmpty()) {
                buffer.append("(");
                String delimiter = "";
                for (ExprNode param : element.getParameters()) {
                    buffer.append(delimiter);
                    delimiter = ", ";
                    buffer.append(param.toExpressionString());
                }
                buffer.append(")");
            }
            delimiterOuter = ".";
            isFirst = false;
        }
    }

    public static void validate(List<ExprChainedSpec> chainSpec, ExprValidationContext validationContext) throws ExprValidationException {
        for (ExprChainedSpec chainElement : chainSpec) {
            ArrayList<ExprNode> validated = new ArrayList<ExprNode>();
            for (ExprNode expr : chainElement.getParameters()) {
                validated.add(ExprNodeUtility.getValidatedSubtree(expr, validationContext));
            }
            chainElement.setParameters(validated);
        }
    }

    public static List<ExprNode> collectChainParameters(List<ExprChainedSpec> chainSpec) {
        ArrayList<ExprNode> result = new ArrayList<ExprNode>();
        for (ExprChainedSpec chainElement : chainSpec) {
            result.addAll(chainElement.getParameters());
        }
        return result;
    }

    public static String printEvaluators(ExprEvaluator[] evaluators) {
        StringWriter writer = new StringWriter();
        String delimiter = "";
        for (int i = 0; i < evaluators.length; ++i) {
            writer.append(delimiter);
            writer.append(evaluators[i].getClass().getSimpleName());
            delimiter = ", ";
        }
        return writer.toString();
    }

    public static ScheduleSpec toCrontabSchedule(List<ExprNode> scheduleSpecExpressionList, StatementContext context) throws ExprValidationException {
        ExprEvaluator[] expressions = new ExprEvaluator[scheduleSpecExpressionList.size()];
        int count = 0;
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(context);
        for (ExprNode parameters : scheduleSpecExpressionList) {
            ExprValidationContext validationContext = new ExprValidationContext(new StreamTypeServiceImpl(context.getEngineURI(), false), context.getMethodResolutionService(), null, context.getSchedulingService(), context.getVariableService(), evaluatorContextStmt, context.getEventAdapterService(), context.getStatementName(), context.getStatementId(), context.getAnnotations(), context.getContextDescriptor());
            ExprNode node = ExprNodeUtility.getValidatedSubtree(parameters, validationContext);
            expressions[count++] = node.getExprEvaluator();
        }
        try {
            Object[] scheduleSpecParameterList = ExprNodeUtility.evaluateExpressions(expressions, evaluatorContextStmt);
            return ScheduleSpecUtil.computeValues(scheduleSpecParameterList);
        }
        catch (ScheduleParameterException e) {
            throw new IllegalArgumentException("Invalid schedule specification : " + e.getMessage(), e);
        }
    }

    public static Object[] evaluateExpressions(ExprEvaluator[] parameters, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] results = new Object[parameters.length];
        int count = 0;
        for (ExprEvaluator expr : parameters) {
            try {
                results[count] = expr.evaluate(null, true, exprEvaluatorContext);
                ++count;
            }
            catch (RuntimeException ex) {
                String message = "Failed expression evaluation in crontab timer-at for parameter " + count + ": " + ex.getMessage();
                log.error((Object)message, (Throwable)ex);
                throw new IllegalArgumentException(message);
            }
        }
        return results;
    }

    protected static class MappedPropertyParseResult {
        private String className;
        private String methodName;
        private String argString;

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getArgString() {
            return this.argString;
        }

        public MappedPropertyParseResult(String className, String methodName, String argString) {
            this.className = className;
            this.methodName = methodName;
            this.argString = argString;
        }
    }
}

