/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Map;

public class ExprNotNode
extends ExprNodeBase
implements ExprEvaluator {
    private transient ExprEvaluator evaluator;
    private static final long serialVersionUID = -5958420226808323787L;

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().size() != 1) {
            throw new ExprValidationException("The NOT node requires exactly 1 child node");
        }
        this.evaluator = this.getChildNodes().get(0).getExprEvaluator();
        Class childType = this.evaluator.getType();
        if (!JavaClassHelper.isBoolean(childType)) {
            throw new ExprValidationException("Incorrect use of NOT clause, sub-expressions do not return boolean");
        }
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean evaluated = (Boolean)this.evaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (evaluated == null) {
            return null;
        }
        return evaluated == false;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("NOT(");
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprNotNode;
    }
}

