/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.FrequencyParameter;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNumberSetFrequency
extends ExprNodeBase
implements ExprEvaluator {
    private static final Log log = LogFactory.getLog(ExprNumberSetFrequency.class);
    private transient ExprEvaluator evaluator;
    private static final long serialVersionUID = -5389069399403078192L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public String toExpressionString() {
        return "*/" + this.getChildNodes().get(0);
    }

    @Override
    public boolean isConstantResult() {
        return this.getChildNodes().get(0).isConstantResult();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprNumberSetFrequency;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.evaluator = this.getChildNodes().get(0).getExprEvaluator();
        Class type = this.evaluator.getType();
        if (!JavaClassHelper.isNumericNonFP(type)) {
            throw new ExprValidationException("Frequency operator requires an integer-type parameter");
        }
    }

    @Override
    public Class getType() {
        return FrequencyParameter.class;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object value = this.evaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (value == null) {
            log.warn((Object)"Null value returned for frequency parameter");
            return new FrequencyParameter(Integer.MAX_VALUE);
        }
        int intValue = ((Number)value).intValue();
        return new FrequencyParameter(intValue);
    }
}

