/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.RangeParameter;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNumberSetRange
extends ExprNodeBase
implements ExprEvaluator {
    private static final Log log = LogFactory.getLog(ExprNumberSetRange.class);
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -3777415170380735662L;

    @Override
    public String toExpressionString() {
        return this.getChildNodes().get(0).toExpressionString() + ":" + this.getChildNodes().get(1).toExpressionString();
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isConstantResult() {
        return this.getChildNodes().get(0).isConstantResult() && this.getChildNodes().get(1).isConstantResult();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprNumberSetRange;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class typeOne = this.evaluators[0].getType();
        Class typeTwo = this.evaluators[1].getType();
        if (!JavaClassHelper.isNumericNonFP(typeOne) || !JavaClassHelper.isNumericNonFP(typeTwo)) {
            throw new ExprValidationException("Range operator requires integer-type parameters");
        }
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public Class getType() {
        return RangeParameter.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object valueLower = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object valueUpper = this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueLower == null) {
            log.warn((Object)"Null value returned for lower bounds value in range parameter, using zero as lower bounds");
            valueLower = 0;
        }
        if (valueUpper == null) {
            log.warn((Object)"Null value returned for upper bounds value in range parameter, using max as upper bounds");
            valueUpper = Integer.MAX_VALUE;
        }
        int intValueLower = ((Number)valueLower).intValue();
        int intValueUpper = ((Number)valueUpper).intValue();
        return new RangeParameter(intValueLower, intValueUpper);
    }
}

