/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Map;

public class ExprOrNode
extends ExprNodeBase
implements ExprEvaluator {
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -1079540621551505814L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        for (ExprEvaluator child : this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes())) {
            Class childType = child.getType();
            if (JavaClassHelper.isBoolean(childType)) continue;
            throw new ExprValidationException("Incorrect use of OR clause, sub-expressions do not return boolean");
        }
        if (this.getChildNodes().size() <= 1) {
            throw new ExprValidationException("The OR operator requires at least 2 child expressions");
        }
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean result = false;
        for (ExprEvaluator child : this.evaluators) {
            Boolean evaluated = (Boolean)child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (evaluated == null) {
                result = null;
                continue;
            }
            if (!evaluated.booleanValue()) continue;
            return true;
        }
        return result;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        String appendStr = "";
        for (ExprNode child : this.getChildNodes()) {
            buffer.append(appendStr);
            buffer.append(child.toExpressionString());
            appendStr = " OR ";
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprOrNode;
    }
}

