/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.agg.AggregationValidationContext;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprPlugInAggFunctionNodeFactory;
import com.espertech.esper.epl.expression.ExprValidationException;

public class ExprPlugInAggFunctionNode
extends ExprAggregateNodeBase {
    private transient AggregationSupport aggregationSupport;
    private static final long serialVersionUID = 4512085880102791194L;

    public ExprPlugInAggFunctionNode(boolean distinct, AggregationSupport aggregationSupport, String functionName) {
        super(distinct);
        this.aggregationSupport = aggregationSupport;
        aggregationSupport.setFunctionName(functionName);
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        Class[] parameterTypes = new Class[this.getChildNodes().size()];
        Object[] constant = new Object[this.getChildNodes().size()];
        boolean[] isConstant = new boolean[this.getChildNodes().size()];
        ExprNode[] expressions = new ExprNode[this.getChildNodes().size()];
        int count = 0;
        boolean hasDataWindows = true;
        for (ExprNode child : this.getChildNodes()) {
            if (child.isConstantResult()) {
                isConstant[count] = true;
                constant[count] = child.getExprEvaluator().evaluate(null, true, exprEvaluatorContext);
            }
            parameterTypes[count] = child.getExprEvaluator().getType();
            expressions[count] = child;
            ++count;
            if (ExprNodeUtility.hasRemoveStream(child, streamTypeService)) continue;
            hasDataWindows = false;
        }
        AggregationValidationContext context = new AggregationValidationContext(parameterTypes, isConstant, constant, super.isDistinct(), hasDataWindows, expressions);
        try {
            this.aggregationSupport.validate(context);
        }
        catch (RuntimeException ex) {
            throw new ExprValidationException("Plug-in aggregation function '" + this.aggregationSupport.getFunctionName() + "' failed validation: " + ex.getMessage());
        }
        Class childType = null;
        if (this.getChildNodes().size() > 0) {
            childType = this.getChildNodes().get(0).getExprEvaluator().getType();
        }
        return new ExprPlugInAggFunctionNodeFactory(this.aggregationSupport, super.isDistinct(), childType);
    }

    @Override
    public String getAggregationFunctionName() {
        return this.aggregationSupport.getFunctionName();
    }

    @Override
    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        if (!(node instanceof ExprPlugInAggFunctionNode)) {
            return false;
        }
        ExprPlugInAggFunctionNode other = (ExprPlugInAggFunctionNode)node;
        return other.getAggregationFunctionName().equals(this.getAggregationFunctionName());
    }
}

