/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.ConfigurationPlugInSingleRowFunction;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalTypeInfo;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrapFactory;
import com.espertech.esper.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.epl.expression.ExprChainedSpec;
import com.espertech.esper.epl.expression.ExprDotEval;
import com.espertech.esper.epl.expression.ExprDotEvalStaticMethod;
import com.espertech.esper.epl.expression.ExprDotNodeFilterAnalyzerInputStatic;
import com.espertech.esper.epl.expression.ExprDotNodeUtility;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeInnerNodeProvider;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprNodeVisitor;
import com.espertech.esper.epl.expression.ExprNodeVisitorWithParent;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprPlugInSingleRowNode
extends ExprNodeBase
implements ExprNodeInnerNodeProvider {
    private static final long serialVersionUID = 2485214890449563098L;
    private static final Log log = LogFactory.getLog(ExprPlugInSingleRowNode.class);
    private final String functionName;
    private final Class clazz;
    private final List<ExprChainedSpec> chainSpec;
    private final ConfigurationPlugInSingleRowFunction.ValueCache valueCache;
    private transient boolean isReturnsConstantResult;
    private transient ExprEvaluator evaluator;

    public ExprPlugInSingleRowNode(String functionName, Class clazz, List<ExprChainedSpec> chainSpec, ConfigurationPlugInSingleRowFunction.ValueCache valueCache) {
        this.functionName = functionName;
        this.clazz = clazz;
        this.chainSpec = chainSpec;
        this.valueCache = valueCache;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    public List<ExprChainedSpec> getChainSpec() {
        return this.chainSpec;
    }

    @Override
    public boolean isConstantResult() {
        return this.isReturnsConstantResult;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Class getClazz() {
        return this.clazz;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.functionName);
        ExprNodeUtility.toExpressionString(this.chainSpec, buffer, true);
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprPlugInSingleRowNode)) {
            return false;
        }
        ExprPlugInSingleRowNode other = (ExprPlugInSingleRowNode)node;
        if (other.chainSpec.size() != this.chainSpec.size()) {
            return false;
        }
        for (int i = 0; i < this.chainSpec.size(); ++i) {
            if (this.chainSpec.get(i).equals(other.chainSpec.get(i))) continue;
            return false;
        }
        return other.clazz == this.clazz && other.functionName.endsWith(this.functionName);
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        FastMethod staticMethod;
        Method method;
        ExprNodeUtility.validate(this.chainSpec, validationContext);
        ArrayList<ExprChainedSpec> chainList = new ArrayList<ExprChainedSpec>(this.chainSpec);
        ExprChainedSpec firstItem = (ExprChainedSpec)chainList.remove(0);
        Class[] paramTypes = new Class[firstItem.getParameters().size()];
        ExprEvaluator[] childEvals = new ExprEvaluator[firstItem.getParameters().size()];
        int count = 0;
        boolean allConstants = true;
        for (ExprNode childNode : firstItem.getParameters()) {
            ExprEvaluator eval;
            if (childNode instanceof ExprLambdaGoesNode) {
                throw new ExprValidationException("Unexpected lambda-expression encountered as parameter to UDF or static method");
            }
            childEvals[count] = eval = childNode.getExprEvaluator();
            paramTypes[count] = eval.getType();
            ++count;
            if (childNode.isConstantResult()) continue;
            allConstants = false;
        }
        if (this.valueCache == ConfigurationPlugInSingleRowFunction.ValueCache.DISABLED) {
            this.isReturnsConstantResult = false;
        } else if (this.valueCache == ConfigurationPlugInSingleRowFunction.ValueCache.CONFIGURED) {
            this.isReturnsConstantResult = validationContext.getMethodResolutionService().isUdfCache() && allConstants && chainList.isEmpty();
        } else if (this.valueCache == ConfigurationPlugInSingleRowFunction.ValueCache.ENABLED) {
            this.isReturnsConstantResult = allConstants && chainList.isEmpty();
        } else {
            throw new IllegalStateException("Invalid value cache code " + (Object)((Object)this.valueCache));
        }
        try {
            method = validationContext.getMethodResolutionService().resolveMethod(this.clazz.getName(), firstItem.getName(), paramTypes);
            FastClass declaringClass = FastClass.create((ClassLoader)Thread.currentThread().getContextClassLoader(), method.getDeclaringClass());
            staticMethod = declaringClass.getMethod(method);
        }
        catch (Exception e) {
            throw new ExprValidationException(e.getMessage());
        }
        ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(method, validationContext.getEventAdapterService(), chainList);
        ExprDotEvalTypeInfo typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : ExprDotEvalTypeInfo.scalarOrUnderlying(method.getReturnType());
        ExprDotEval[] eval = ExprDotNodeUtility.getChainEvaluators(typeInfo, chainList, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic()).getChainWithUnpack();
        this.evaluator = new ExprDotEvalStaticMethod(validationContext.getStatementName(), this.clazz.getName(), staticMethod, childEvals, allConstants, optionalLambdaWrap, eval);
        if (this.isReturnsConstantResult) {
            final Object result = this.evaluator.evaluate(null, true, null);
            this.evaluator = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return result;
                }

                @Override
                public Class getType() {
                    return staticMethod.getReturnType();
                }

                @Override
                public Map<String, Object> getEventType() throws ExprValidationException {
                    return null;
                }
            };
        }
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec, this);
    }

    @Override
    public void replaceUnlistedChildNode(ExprNode nodeToReplace, ExprNode newNode) {
        ExprNodeUtility.replaceChainChildNode(nodeToReplace, newNode, this.chainSpec);
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return ExprNodeUtility.collectChainParameters(this.chainSpec);
    }
}

