/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprConstantNode;
import com.espertech.esper.epl.expression.ExprConstantNodeImpl;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.PreviousType;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Collection;
import java.util.Map;

public class ExprPreviousNode
extends ExprNodeBase
implements ExprEvaluator,
ExprEvaluatorEnumeration {
    private static final long serialVersionUID = 0L;
    private final PreviousType previousType;
    private Class resultType;
    private int streamNumber;
    private Integer constantIndexNumber;
    private boolean isConstantIndex;
    private transient EventType enumerationMethodType;
    private transient ExprPreviousEvalStrategy evaluator;

    public ExprPreviousNode(PreviousType previousType) {
        this.previousType = previousType;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    public void setEvaluator(ExprPreviousEvalStrategy evaluator) {
        this.evaluator = evaluator;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public Integer getConstantIndexNumber() {
        return this.constantIndexNumber;
    }

    public boolean isConstantIndex() {
        return this.isConstantIndex;
    }

    public Class getResultType() {
        return this.resultType;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().size() > 2 || this.getChildNodes().isEmpty()) {
            throw new ExprValidationException("Previous node must have 1 or 2 child nodes");
        }
        if (this.getChildNodes().size() == 1) {
            if (this.previousType == PreviousType.PREV) {
                this.getChildNodes().add(0, new ExprConstantNodeImpl(1));
            } else {
                this.getChildNodes().add(0, new ExprConstantNodeImpl(0));
            }
        }
        if (this.getChildNodes().get(1) instanceof ExprConstantNode) {
            ExprNode first = this.getChildNodes().get(0);
            ExprNode second = this.getChildNodes().get(1);
            this.getChildNodes().clear();
            this.getChildNodes().add(second);
            this.getChildNodes().add(first);
        }
        if (this.getChildNodes().get(0).isConstantResult()) {
            ExprNode constantNode = this.getChildNodes().get(0);
            Object value = constantNode.getExprEvaluator().evaluate(null, false, validationContext.getExprEvaluatorContext());
            if (!(value instanceof Number)) {
                throw new ExprValidationException("Previous function requires an integer index parameter or expression");
            }
            Number valueNumber = (Number)value;
            if (JavaClassHelper.isFloatingPointNumber(valueNumber)) {
                throw new ExprValidationException("Previous function requires an integer index parameter or expression");
            }
            this.constantIndexNumber = valueNumber.intValue();
            this.isConstantIndex = true;
        }
        if (this.getChildNodes().get(1) instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes().get(1);
            this.streamNumber = identNode.getStreamId();
            this.resultType = JavaClassHelper.getBoxedType(this.getChildNodes().get(1).getExprEvaluator().getType());
        } else if (this.getChildNodes().get(1) instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode streamNode = (ExprStreamUnderlyingNode)this.getChildNodes().get(1);
            this.streamNumber = streamNode.getStreamId();
            this.resultType = JavaClassHelper.getBoxedType(this.getChildNodes().get(1).getExprEvaluator().getType());
            this.enumerationMethodType = validationContext.getStreamTypeService().getEventTypes()[streamNode.getStreamId()];
        } else {
            throw new ExprValidationException("Previous function requires an event property as parameter");
        }
        if (this.previousType == PreviousType.PREVCOUNT) {
            this.resultType = Long.class;
        }
        if (this.previousType == PreviousType.PREVWINDOW) {
            this.resultType = JavaClassHelper.getArrayType(this.resultType);
        }
        if (validationContext.getViewResourceDelegate() == null) {
            throw new ExprValidationException("Previous function cannot be used in this context");
        }
        validationContext.getViewResourceDelegate().addPreviousRequest(this);
    }

    public PreviousType getPreviousType() {
        return this.previousType;
    }

    @Override
    public Class getType() {
        return this.resultType;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (!isNewData) {
            return null;
        }
        return this.evaluator.evaluateGetCollEvents(eventsPerStream, context);
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (!isNewData) {
            return null;
        }
        return this.evaluator.evaluateGetEventBean(eventsPerStream, context);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (!isNewData) {
            return null;
        }
        return this.evaluator.evaluateGetCollScalar(eventsPerStream, context);
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService) throws ExprValidationException {
        if (this.previousType == PreviousType.PREV || this.previousType == PreviousType.PREVTAIL) {
            return null;
        }
        return this.enumerationMethodType;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, String statementId) throws ExprValidationException {
        if (this.previousType == PreviousType.PREV || this.previousType == PreviousType.PREVTAIL) {
            return this.enumerationMethodType;
        }
        return null;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        if (this.resultType.isArray()) {
            return this.resultType.getComponentType();
        }
        return this.resultType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (!isNewData) {
            return null;
        }
        return this.evaluator.evaluate(eventsPerStream, exprEvaluatorContext);
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.previousType.toString().toLowerCase());
        buffer.append("(");
        if (this.previousType == PreviousType.PREVCOUNT || this.previousType == PreviousType.PREVWINDOW) {
            buffer.append(this.getChildNodes().get(1).toExpressionString());
        } else {
            buffer.append(this.getChildNodes().get(0).toExpressionString());
            buffer.append(", ");
            buffer.append(this.getChildNodes().get(1).toExpressionString());
        }
        buffer.append(')');
        return buffer.toString();
    }

    public int hashCode() {
        return this.previousType != null ? this.previousType.hashCode() : 0;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (node == null || this.getClass() != node.getClass()) {
            return false;
        }
        ExprPreviousNode that = (ExprPreviousNode)node;
        return this.previousType == that.previousType;
    }
}

