/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import java.util.Map;

public class ExprPropertyExistsNode
extends ExprNodeBase
implements ExprEvaluator {
    private ExprIdentNode identNode;
    private static final long serialVersionUID = -6304444201237275628L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().size() != 1) {
            throw new ExprValidationException("Exists function node must have exactly 1 child node");
        }
        if (!(this.getChildNodes().get(0) instanceof ExprIdentNode)) {
            throw new ExprValidationException("Exists function expects an property value expression as the child node");
        }
        this.identNode = (ExprIdentNode)this.getChildNodes().get(0);
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.identNode.getExprEvaluatorIdent().evaluatePropertyExists(eventsPerStream, isNewData);
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("exists(");
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprPropertyExistsNode;
    }
}

