/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import java.util.Map;

public class ExprStreamUnderlyingNodeImpl
extends ExprNodeBase
implements ExprEvaluator,
ExprStreamUnderlyingNode {
    private final String streamName;
    private final boolean isWildcard;
    private int streamNum = -1;
    private Class type;
    private static final long serialVersionUID = 6611578192872250478L;

    public ExprStreamUnderlyingNodeImpl(String streamName, boolean isWildcard) {
        if (streamName == null && !isWildcard) {
            throw new IllegalArgumentException("Stream name is null");
        }
        this.streamName = streamName;
        this.isWildcard = isWildcard;
    }

    public ExprStreamUnderlyingNodeImpl(String streamName, boolean wildcard, int streamNum, Class type) {
        this.streamName = streamName;
        this.isWildcard = wildcard;
        this.streamNum = streamNum;
        this.type = type;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.isWildcard) {
            if (validationContext.getStreamTypeService().getStreamNames().length > 1) {
                throw new ExprValidationException("Wildcard must be stream wildcard if specifying multiple streams, use the 'streamname.*' syntax instead");
            }
            this.streamNum = 0;
        } else {
            this.streamNum = validationContext.getStreamTypeService().getStreamNumForStreamName(this.streamName);
        }
        if (this.streamNum == -1) {
            throw new ExprValidationException("Stream by name '" + this.streamName + "' could not be found among all streams");
        }
        EventType eventType = validationContext.getStreamTypeService().getEventTypes()[this.streamNum];
        this.type = eventType.getUnderlyingType();
    }

    @Override
    public Class getType() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Stream underlying node has not been validated");
        }
        return this.type;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public int getStreamId() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Stream underlying node has not been validated");
        }
        return this.streamNum;
    }

    public String toString() {
        return "streamName=" + this.streamName + " streamNum=" + this.streamNum;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        return event.getUnderlying();
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.streamName);
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprStreamUnderlyingNodeImpl)) {
            return false;
        }
        ExprStreamUnderlyingNodeImpl other = (ExprStreamUnderlyingNodeImpl)node;
        if (this.isWildcard != other.isWildcard) {
            return false;
        }
        if (this.isWildcard) {
            return true;
        }
        return this.streamName.equals(other.streamName);
    }
}

