/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.datetime.eval.TimePeriod;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.ExprVariableNode;
import com.espertech.esper.util.JavaClassHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprTimePeriodImpl
extends ExprNodeBase
implements ExprEvaluator,
ExprTimePeriod {
    private static final Log log = LogFactory.getLog(ExprTimePeriodImpl.class);
    private final boolean hasYear;
    private final boolean hasMonth;
    private final boolean hasWeek;
    private final boolean hasDay;
    private final boolean hasHour;
    private final boolean hasMinute;
    private final boolean hasSecond;
    private final boolean hasMillisecond;
    private boolean hasVariable;
    private transient ExprEvaluator[] evaluators;
    private transient TimePeriodAdder[] adders;
    private static final long serialVersionUID = -7229827032500659319L;

    public ExprTimePeriodImpl(boolean hasYear, boolean hasMonth, boolean hasWeek, boolean hasDay, boolean hasHour, boolean hasMinute, boolean hasSecond, boolean hasMillisecond) {
        this.hasYear = hasYear;
        this.hasMonth = hasMonth;
        this.hasWeek = hasWeek;
        this.hasDay = hasDay;
        this.hasHour = hasHour;
        this.hasMinute = hasMinute;
        this.hasSecond = hasSecond;
        this.hasMillisecond = hasMillisecond;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isHasDay() {
        return this.hasDay;
    }

    @Override
    public boolean isHasHour() {
        return this.hasHour;
    }

    @Override
    public boolean isHasMinute() {
        return this.hasMinute;
    }

    @Override
    public boolean isHasSecond() {
        return this.hasSecond;
    }

    @Override
    public boolean isHasMillisecond() {
        return this.hasMillisecond;
    }

    @Override
    public boolean isHasYear() {
        return this.hasYear;
    }

    @Override
    public boolean isHasMonth() {
        return this.hasMonth;
    }

    @Override
    public boolean isHasWeek() {
        return this.hasWeek;
    }

    @Override
    public boolean hasVariable() {
        return this.hasVariable;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        for (ExprNode childNode : this.getChildNodes()) {
            this.validate(childNode);
        }
        ArrayDeque<TimePeriodAdder> list = new ArrayDeque<TimePeriodAdder>();
        if (this.hasYear) {
            list.add(new TimePeriodAdderYear());
        }
        if (this.hasMonth) {
            list.add(new TimePeriodAdderMonth());
        }
        if (this.hasWeek) {
            list.add(new TimePeriodAdderWeek());
        }
        if (this.hasDay) {
            list.add(new TimePeriodAdderDay());
        }
        if (this.hasHour) {
            list.add(new TimePeriodAdderHour());
        }
        if (this.hasMinute) {
            list.add(new TimePeriodAdderMinute());
        }
        if (this.hasSecond) {
            list.add(new TimePeriodAdderSecond());
        }
        if (this.hasMillisecond) {
            list.add(new TimePeriodAdderMSec());
        }
        this.adders = list.toArray(new TimePeriodAdder[list.size()]);
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    private void validate(ExprNode expression) throws ExprValidationException {
        if (expression == null) {
            return;
        }
        Class returnType = expression.getExprEvaluator().getType();
        if (!JavaClassHelper.isNumeric(returnType)) {
            throw new ExprValidationException("Time period expression requires a numeric parameter type");
        }
        if (expression instanceof ExprVariableNode) {
            this.hasVariable = true;
        }
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        double seconds = 0.0;
        for (int i = 0; i < this.adders.length; ++i) {
            Double result = this.eval(this.evaluators[i], eventsPerStream, exprEvaluatorContext);
            if (result == null) {
                this.logWarn(i);
                return null;
            }
            seconds += this.adders[i].compute(result);
        }
        return seconds;
    }

    private void logWarn(int ctr) {
        log.warn((Object)("Time period expression returned a null value for expression '" + this.getChildNodes().get(ctr).toExpressionString() + "'"));
    }

    @Override
    public Class getType() {
        return Double.class;
    }

    @Override
    public boolean isConstantResult() {
        for (ExprNode child : this.getChildNodes()) {
            if (child.isConstantResult()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toExpressionString() {
        StringBuffer buf = new StringBuffer();
        int exprCtr = 0;
        if (this.hasYear) {
            buf.append(this.getChildNodes().get(exprCtr++).toExpressionString());
            buf.append(" years ");
        }
        if (this.hasMonth) {
            buf.append(this.getChildNodes().get(exprCtr++).toExpressionString());
            buf.append(" months ");
        }
        if (this.hasWeek) {
            buf.append(this.getChildNodes().get(exprCtr++).toExpressionString());
            buf.append(" weeks ");
        }
        if (this.hasDay) {
            buf.append(this.getChildNodes().get(exprCtr++).toExpressionString());
            buf.append(" days ");
        }
        if (this.hasHour) {
            buf.append(this.getChildNodes().get(exprCtr++).toExpressionString());
            buf.append(" hours ");
        }
        if (this.hasMinute) {
            buf.append(this.getChildNodes().get(exprCtr++).toExpressionString());
            buf.append(" minutes ");
        }
        if (this.hasSecond) {
            buf.append(this.getChildNodes().get(exprCtr++).toExpressionString());
            buf.append(" seconds ");
        }
        if (this.hasMillisecond) {
            buf.append(this.getChildNodes().get(exprCtr).toExpressionString());
            buf.append(" milliseconds ");
        }
        return buf.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprTimePeriodImpl)) {
            return false;
        }
        ExprTimePeriodImpl other = (ExprTimePeriodImpl)node;
        if (this.hasYear != other.hasYear) {
            return false;
        }
        if (this.hasMonth != other.hasMonth) {
            return false;
        }
        if (this.hasWeek != other.hasWeek) {
            return false;
        }
        if (this.hasDay != other.hasDay) {
            return false;
        }
        if (this.hasHour != other.hasHour) {
            return false;
        }
        if (this.hasMinute != other.hasMinute) {
            return false;
        }
        if (this.hasSecond != other.hasSecond) {
            return false;
        }
        return this.hasMillisecond == other.hasMillisecond;
    }

    private Double eval(ExprEvaluator expr, EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        Object value = expr.evaluate(events, true, exprEvaluatorContext);
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof BigInteger) {
            return ((Number)value).doubleValue();
        }
        return ((Number)value).doubleValue();
    }

    @Override
    public TimePeriod evaluateGetTimePeriod(EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        int exprCtr = 0;
        Integer year = null;
        if (this.hasYear) {
            year = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer month = null;
        if (this.hasMonth) {
            month = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer week = null;
        if (this.hasWeek) {
            week = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer day = null;
        if (this.hasDay) {
            day = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer hours = null;
        if (this.hasHour) {
            hours = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer minutes = null;
        if (this.hasMinute) {
            minutes = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer seconds = null;
        if (this.hasSecond) {
            seconds = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer milliseconds = null;
        if (this.hasMillisecond) {
            milliseconds = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        return new TimePeriod(year, month, week, day, hours, minutes, seconds, milliseconds);
    }

    private Integer getInt(Object evaluated) {
        if (evaluated == null) {
            return null;
        }
        return ((Number)evaluated).intValue();
    }

    public static class TimePeriodAdderMSec
    implements TimePeriodAdder {
        @Override
        public double compute(Double value) {
            return value / 1000.0;
        }
    }

    public static class TimePeriodAdderSecond
    implements TimePeriodAdder {
        @Override
        public double compute(Double value) {
            return value;
        }
    }

    public static class TimePeriodAdderMinute
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 60.0;

        @Override
        public double compute(Double value) {
            return value * 60.0;
        }
    }

    public static class TimePeriodAdderHour
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 3600.0;

        @Override
        public double compute(Double value) {
            return value * 3600.0;
        }
    }

    public static class TimePeriodAdderDay
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 86400.0;

        @Override
        public double compute(Double value) {
            return value * 86400.0;
        }
    }

    public static class TimePeriodAdderWeek
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 604800.0;

        @Override
        public double compute(Double value) {
            return value * 604800.0;
        }
    }

    public static class TimePeriodAdderMonth
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 2592000.0;

        @Override
        public double compute(Double value) {
            return value * 2592000.0;
        }
    }

    public static class TimePeriodAdderYear
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 3.1536E7;

        @Override
        public double compute(Double value) {
            return value * 3.1536E7;
        }
    }

    public static interface TimePeriodAdder {
        public double compute(Double var1);
    }
}

