/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.assemble;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.join.assemble.BaseAssemblyNode;
import com.espertech.esper.epl.join.rep.Node;
import com.espertech.esper.util.IndentWriter;
import java.util.List;
import java.util.Set;

public class LeafAssemblyNode
extends BaseAssemblyNode {
    public LeafAssemblyNode(int streamNum, int numStreams) {
        super(streamNum, numStreams);
    }

    @Override
    public void init(List<Node>[] result) {
    }

    @Override
    public void process(List<Node>[] result) {
        List<Node> nodes = result[this.streamNum];
        if (nodes == null) {
            return;
        }
        for (Node node : nodes) {
            Set<EventBean> events = node.getEvents();
            for (EventBean event : events) {
                this.processEvent(event, node);
            }
        }
    }

    private void processEvent(EventBean event, Node currentNode) {
        EventBean[] row = new EventBean[this.numStreams];
        row[this.streamNum] = event;
        this.parentNode.result(row, this.streamNum, currentNode.getParentEvent(), currentNode.getParent());
    }

    @Override
    public void result(EventBean[] row, int streamNum, EventBean myEvent, Node myNode) {
        throw new UnsupportedOperationException("Leaf node cannot process child results");
    }

    @Override
    public void print(IndentWriter indentWriter) {
        indentWriter.println("LeafAssemblyNode streamNum=" + this.streamNum);
    }
}

