/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.base.QueryStrategy;
import com.espertech.esper.epl.join.exec.base.ExecNode;
import java.util.LinkedList;
import java.util.Set;

public class ExecNodeQueryStrategy
implements QueryStrategy {
    private int forStream;
    private int numStreams;
    private ExecNode execNode;

    public ExecNodeQueryStrategy(int forStream, int numStreams, ExecNode execNode) {
        this.forStream = forStream;
        this.numStreams = numStreams;
        this.execNode = execNode;
    }

    @Override
    public void lookup(EventBean[] lookupEvents, Set<MultiKey<EventBean>> joinSet, ExprEvaluatorContext exprEvaluatorContext) {
        if (lookupEvents == null) {
            return;
        }
        for (EventBean event : lookupEvents) {
            EventBean[] prototype = new EventBean[this.numStreams];
            prototype[this.forStream] = event;
            LinkedList<EventBean[]> results = new LinkedList<EventBean[]>();
            this.execNode.process(event, prototype, results, exprEvaluatorContext);
            for (EventBean[] row : results) {
                joinSet.add(new MultiKey<EventBean>(row));
            }
        }
    }

    protected int getForStream() {
        return this.forStream;
    }

    protected int getNumStreams() {
        return this.numStreams;
    }

    protected ExecNode getExecNode() {
        return this.execNode;
    }
}

