/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.base.JoinSetComposer;
import com.espertech.esper.epl.join.base.JoinSetComposerUtil;
import com.espertech.esper.epl.join.base.QueryStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class JoinSetComposerStreamToWinImpl
implements JoinSetComposer {
    private final EventTable[][] repositories;
    private final int streamNumber;
    private final QueryStrategy queryStrategy;
    private final boolean isResetSelfJoinRepositories;
    private final boolean[] selfJoinRepositoryResets;
    private Set<MultiKey<EventBean>> emptyResults = new LinkedHashSet<MultiKey<EventBean>>();
    private Set<MultiKey<EventBean>> newResults = new LinkedHashSet<MultiKey<EventBean>>();

    public JoinSetComposerStreamToWinImpl(Map<String, EventTable>[] repositories, boolean isPureSelfJoin, int streamNumber, QueryStrategy queryStrategy, boolean[] selfJoinRepositoryResets) {
        this.repositories = JoinSetComposerUtil.toArray(repositories);
        this.streamNumber = streamNumber;
        this.queryStrategy = queryStrategy;
        this.selfJoinRepositoryResets = selfJoinRepositoryResets;
        if (isPureSelfJoin) {
            this.isResetSelfJoinRepositories = true;
            Arrays.fill(selfJoinRepositoryResets, true);
        } else {
            boolean flag = false;
            for (boolean selfJoinRepositoryReset : selfJoinRepositoryResets) {
                flag |= selfJoinRepositoryReset;
            }
            this.isResetSelfJoinRepositories = flag;
        }
    }

    @Override
    public void init(EventBean[][] eventsPerStream) {
        for (int i = 0; i < eventsPerStream.length; ++i) {
            if (eventsPerStream[i] == null || i == this.streamNumber) continue;
            for (int j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].add(eventsPerStream[i]);
            }
        }
    }

    @Override
    public void destroy() {
        for (EventTable[] repository : this.repositories) {
            if (repository == null) continue;
            for (EventTable table : repository) {
                table.clear();
            }
        }
    }

    @Override
    public UniformPair<Set<MultiKey<EventBean>>> join(EventBean[][] newDataPerStream, EventBean[][] oldDataPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        int j;
        int i;
        this.newResults.clear();
        for (i = 0; i < newDataPerStream.length; ++i) {
            if (newDataPerStream[i] == null || i == this.streamNumber) continue;
            for (j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].add(newDataPerStream[i]);
            }
        }
        for (i = 0; i < oldDataPerStream.length; ++i) {
            if (oldDataPerStream[i] == null || i == this.streamNumber) continue;
            for (j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].remove(oldDataPerStream[i]);
            }
        }
        if (newDataPerStream[this.streamNumber] != null) {
            this.queryStrategy.lookup(newDataPerStream[this.streamNumber], this.newResults, exprEvaluatorContext);
        }
        if (this.isResetSelfJoinRepositories) {
            for (i = 0; i < this.selfJoinRepositoryResets.length; ++i) {
                if (!this.selfJoinRepositoryResets[i]) continue;
                for (j = 0; j < this.repositories[i].length; ++j) {
                    this.repositories[i][j].clear();
                }
            }
        }
        return new UniformPair<Set<MultiKey<EventBean>>>(this.newResults, this.emptyResults);
    }

    @Override
    public Set<MultiKey<EventBean>> staticJoin() {
        throw new UnsupportedOperationException("Iteration over a unidirectional join is not supported");
    }
}

