/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQuery;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQueryFactory;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.join.table.PropertyCompositeEventTable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class CompositeTableLookupStrategy
implements JoinExecTableLookupStrategy {
    private final EventType eventType;
    private final PropertyCompositeEventTable index;
    private final CompositeIndexQuery chain;
    private final List<QueryGraphValueEntryRange> rangeKeyPairs;

    public CompositeTableLookupStrategy(EventType eventType, int lookupStream, List<QueryGraphValueEntryHashKeyed> hashKeys, List<QueryGraphValueEntryRange> rangeKeyPairs, PropertyCompositeEventTable index) {
        this.eventType = eventType;
        this.index = index;
        this.rangeKeyPairs = rangeKeyPairs;
        this.chain = CompositeIndexQueryFactory.makeJoinSingleLookupStream(false, lookupStream, hashKeys, index.getOptKeyCoercedTypes(), rangeKeyPairs, index.getOptRangeCoercedTypes());
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public PropertyCompositeEventTable getIndex() {
        return this.index;
    }

    @Override
    public Set<EventBean> lookup(EventBean event, Cursor cursor, ExprEvaluatorContext context) {
        Set<EventBean> result = this.chain.get(event, this.index.getIndex(), context);
        if (result != null && result.isEmpty()) {
            return null;
        }
        return result;
    }

    public String toString() {
        return "CompositeTableLookupStrategy indexProps=" + Arrays.toString(this.rangeKeyPairs.toArray()) + " index=(" + this.index + ')';
    }
}

