/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.exec.base.ExecNode;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.util.IndentWriter;
import com.espertech.esper.view.HistoricalEventViewable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HistoricalDataExecNode
extends ExecNode {
    private static final Log log = LogFactory.getLog(HistoricalDataExecNode.class);
    private final EventBean[][] lookupRows1Event;
    private final int numStreams;
    private final HistoricalEventViewable historicalEventViewable;
    private final PollResultIndexingStrategy indexingStrategy;
    private final HistoricalIndexLookupStrategy indexLookupStrategy;
    private final int historicalStreamNumber;

    public HistoricalDataExecNode(HistoricalEventViewable historicalEventViewable, PollResultIndexingStrategy indexingStrategy, HistoricalIndexLookupStrategy indexLookupStrategy, int numStreams, int historicalStreamNumber) {
        this.historicalEventViewable = historicalEventViewable;
        this.indexingStrategy = indexingStrategy;
        this.indexLookupStrategy = indexLookupStrategy;
        this.numStreams = numStreams;
        this.historicalStreamNumber = historicalStreamNumber;
        this.lookupRows1Event = new EventBean[1][];
        this.lookupRows1Event[0] = new EventBean[numStreams];
    }

    @Override
    public void process(EventBean lookupEvent, EventBean[] prefillPath, List<EventBean[]> result, ExprEvaluatorContext exprEvaluatorContext) {
        EventTable[] indexPerLookupRow;
        this.lookupRows1Event[0] = prefillPath;
        for (EventTable index : indexPerLookupRow = this.historicalEventViewable.poll(this.lookupRows1Event, this.indexingStrategy, exprEvaluatorContext)) {
            Iterator<EventBean> subsetIter = this.indexLookupStrategy.lookup(lookupEvent, index, exprEvaluatorContext);
            if (subsetIter == null) continue;
            while (subsetIter.hasNext()) {
                EventBean[] resultRow = new EventBean[this.numStreams];
                System.arraycopy(prefillPath, 0, resultRow, 0, this.numStreams);
                resultRow[this.historicalStreamNumber] = subsetIter.next();
                result.add(resultRow);
            }
        }
    }

    @Override
    public void print(IndentWriter writer) {
        writer.println("HistoricalDataExecNode");
    }
}

