/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import java.util.Set;

public class IndexedTableLookupStrategySingleExpr
implements JoinExecTableLookupStrategy {
    private final PropertyIndexedEventTableSingle index;
    private final ExprEvaluator exprEvaluator;
    private final int streamNum;
    private final EventBean[] eventsPerStream;

    public IndexedTableLookupStrategySingleExpr(ExprNode exprNode, int streamNum, PropertyIndexedEventTableSingle index) {
        if (index == null) {
            throw new IllegalArgumentException("Unexpected null index received");
        }
        this.index = index;
        this.streamNum = streamNum;
        this.eventsPerStream = new EventBean[streamNum + 1];
        this.exprEvaluator = exprNode.getExprEvaluator();
    }

    public PropertyIndexedEventTableSingle getIndex() {
        return this.index;
    }

    @Override
    public Set<EventBean> lookup(EventBean event, Cursor cursor, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventsPerStream[this.streamNum] = event;
        Object key = this.exprEvaluator.evaluate(this.eventsPerStream, true, exprEvaluatorContext);
        return this.index.lookup(key);
    }

    public String toString() {
        return "IndexedTableLookupStrategySingleExpr evaluation index=(" + this.index + ')';
    }
}

