/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.assemble.BaseAssemblyNode;
import com.espertech.esper.epl.join.assemble.ResultAssembler;
import com.espertech.esper.epl.join.exec.base.ExecNode;
import com.espertech.esper.epl.join.exec.base.LookupInstructionExec;
import com.espertech.esper.epl.join.rep.Node;
import com.espertech.esper.epl.join.rep.RepositoryImpl;
import com.espertech.esper.util.IndentWriter;
import java.util.Arrays;
import java.util.List;

public class LookupInstructionExecNode
extends ExecNode {
    private final int rootStream;
    private final String rootStreamName;
    private final int numStreams;
    private final boolean[] requiredPerStream;
    private final LookupInstructionExec[] lookupInstructions;
    private final BaseAssemblyNode[] assemblyInstructions;
    private final MyResultAssembler myResultAssembler;
    private int requireResultsInstruction;

    public LookupInstructionExecNode(int rootStream, String rootStreamName, int numStreams, LookupInstructionExec[] lookupInstructions, boolean[] requiredPerStream, BaseAssemblyNode[] assemblyInstructions) {
        int fromStream;
        this.rootStream = rootStream;
        this.rootStreamName = rootStreamName;
        this.numStreams = numStreams;
        this.lookupInstructions = lookupInstructions;
        this.requiredPerStream = requiredPerStream;
        this.assemblyInstructions = assemblyInstructions;
        this.myResultAssembler = new MyResultAssembler(rootStream);
        assemblyInstructions[assemblyInstructions.length - 1].setParentAssembler(this.myResultAssembler);
        this.requireResultsInstruction = 1;
        for (int i = 1; i < lookupInstructions.length && requiredPerStream[fromStream = lookupInstructions[i].getFromStream()]; ++i) {
            this.requireResultsInstruction = i + 1;
        }
    }

    @Override
    public void process(EventBean lookupEvent, EventBean[] prefillPath, List<EventBean[]> result, ExprEvaluatorContext exprEvaluatorContext) {
        BaseAssemblyNode assemblyNode;
        int i;
        LookupInstructionExec currentInstruction;
        int i2;
        RepositoryImpl repository = new RepositoryImpl(this.rootStream, lookupEvent, this.numStreams);
        boolean processOptional = true;
        for (i2 = 0; i2 < this.requireResultsInstruction; ++i2) {
            currentInstruction = this.lookupInstructions[i2];
            boolean hasResults = currentInstruction.process(repository, exprEvaluatorContext);
            if (hasResults) continue;
            if (currentInstruction.hasRequiredStream()) {
                return;
            }
            if (i2 != 0) continue;
            processOptional = false;
        }
        if (processOptional) {
            for (i2 = this.requireResultsInstruction; i2 < this.lookupInstructions.length; ++i2) {
                currentInstruction = this.lookupInstructions[i2];
                currentInstruction.process(repository, exprEvaluatorContext);
            }
        }
        this.myResultAssembler.setResult(result, lookupEvent);
        List<Node>[] results = repository.getNodesPerStream();
        if (results == null) {
            BaseAssemblyNode lastAssemblyNode = this.assemblyInstructions[this.assemblyInstructions.length - 1];
            lastAssemblyNode.init(null);
            lastAssemblyNode.process(null);
            return;
        }
        for (i = 0; i < this.assemblyInstructions.length; ++i) {
            assemblyNode = this.assemblyInstructions[i];
            assemblyNode.init(results);
        }
        for (i = 0; i < this.assemblyInstructions.length; ++i) {
            assemblyNode = this.assemblyInstructions[i];
            assemblyNode.process(results);
        }
    }

    @Override
    public void print(IndentWriter writer) {
        int i;
        writer.println("LookupInstructionExecNode rootStream=" + this.rootStream + " name=" + this.rootStreamName + " requiredPerStream=" + Arrays.toString(this.requiredPerStream));
        writer.incrIndent();
        for (i = 0; i < this.lookupInstructions.length; ++i) {
            writer.println("lookup inst node " + i);
            writer.incrIndent();
            this.lookupInstructions[i].print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
        writer.incrIndent();
        for (i = 0; i < this.assemblyInstructions.length; ++i) {
            writer.println("assembly inst node " + i);
            writer.incrIndent();
            this.assemblyInstructions[i].print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
    }

    public static class MyResultAssembler
    implements ResultAssembler {
        private final int rootStream;
        private List<EventBean[]> result;
        private EventBean rootEvent;

        public MyResultAssembler(int rootStream) {
            this.rootStream = rootStream;
        }

        public void setResult(List<EventBean[]> result, EventBean rootEvent) {
            this.result = result;
            this.rootEvent = rootEvent;
        }

        @Override
        public void result(EventBean[] row, int fromStreamNum, EventBean myEvent, Node myNode) {
            row[this.rootStream] = this.rootEvent;
            this.result.add(row);
        }
    }
}

