/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.base.ExecNode;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.util.IndentWriter;
import java.util.List;
import java.util.Set;

public class TableLookupExecNode
extends ExecNode {
    private int indexedStream;
    private JoinExecTableLookupStrategy lookupStrategy;

    public TableLookupExecNode(int indexedStream, JoinExecTableLookupStrategy lookupStrategy) {
        this.indexedStream = indexedStream;
        this.lookupStrategy = lookupStrategy;
    }

    public JoinExecTableLookupStrategy getLookupStrategy() {
        return this.lookupStrategy;
    }

    @Override
    public void process(EventBean lookupEvent, EventBean[] prefillPath, List<EventBean[]> result, ExprEvaluatorContext exprEvaluatorContext) {
        Set<EventBean> joinedEvents = this.lookupStrategy.lookup(lookupEvent, null, exprEvaluatorContext);
        if (joinedEvents == null) {
            return;
        }
        for (EventBean joinedEvent : joinedEvents) {
            EventBean[] events = new EventBean[prefillPath.length];
            System.arraycopy(prefillPath, 0, events, 0, events.length);
            events[this.indexedStream] = joinedEvent;
            result.add(events);
        }
    }

    public int getIndexedStream() {
        return this.indexedStream;
    }

    @Override
    public void print(IndentWriter writer) {
        writer.println("TableLookupExecNode indexedStream=" + this.indexedStream + " lookup=" + this.lookupStrategy);
    }
}

