/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.composite;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategy;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyRangeBase;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQuery;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQueryRange;
import com.espertech.esper.event.EventBeanUtility;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class CompositeAccessStrategyRangeNormal
extends CompositeAccessStrategyRangeBase
implements CompositeAccessStrategy {
    private boolean allowReverseRange;

    public CompositeAccessStrategyRangeNormal(boolean isNWOnTrigger, int lookupStream, int numStreams, ExprEvaluator start, boolean includeStart, ExprEvaluator end, boolean includeEnd, Class coercionType, boolean allowReverseRange) {
        super(isNWOnTrigger, lookupStream, numStreams, start, includeStart, end, includeEnd, coercionType);
        this.allowReverseRange = allowReverseRange;
    }

    @Override
    public Set<EventBean> lookup(EventBean event, Map parent, Set<EventBean> result, CompositeIndexQuery next, ExprEvaluatorContext context) {
        NavigableMap submap;
        Object comparableStart = super.evaluateLookupStart(event, context);
        if (comparableStart == null) {
            return null;
        }
        Object comparableEnd = super.evaluateLookupEnd(event, context);
        if (comparableEnd == null) {
            return null;
        }
        TreeMap index = (TreeMap)parent;
        comparableStart = EventBeanUtility.coerce(comparableStart, this.coercionType);
        comparableEnd = EventBeanUtility.coerce(comparableEnd, this.coercionType);
        try {
            submap = index.subMap(comparableStart, this.includeStart, comparableEnd, this.includeEnd);
        }
        catch (IllegalArgumentException ex) {
            if (this.allowReverseRange) {
                submap = index.subMap(comparableEnd, this.includeStart, comparableStart, this.includeEnd);
            }
            return null;
        }
        return CompositeIndexQueryRange.handle(event, submap, null, result, next);
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] eventPerStream, Map parent, Collection<EventBean> result, CompositeIndexQuery next, ExprEvaluatorContext context) {
        NavigableMap submap;
        Object comparableStart = super.evaluatePerStreamStart(eventPerStream, context);
        if (comparableStart == null) {
            return null;
        }
        Object comparableEnd = super.evaluatePerStreamEnd(eventPerStream, context);
        if (comparableEnd == null) {
            return null;
        }
        TreeMap index = (TreeMap)parent;
        comparableStart = EventBeanUtility.coerce(comparableStart, this.coercionType);
        comparableEnd = EventBeanUtility.coerce(comparableEnd, this.coercionType);
        try {
            submap = index.subMap(comparableStart, this.includeStart, comparableEnd, this.includeEnd);
        }
        catch (IllegalArgumentException ex) {
            if (this.allowReverseRange) {
                submap = index.subMap(comparableEnd, this.includeStart, comparableStart, this.includeEnd);
            }
            return null;
        }
        return CompositeIndexQueryRange.handle(eventPerStream, submap, null, result, next);
    }
}

