/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.composite;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexEnterRemove;
import com.espertech.esper.event.EventBeanUtility;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CompositeIndexEnterRemoveRange
implements CompositeIndexEnterRemove {
    private final EventPropertyGetter propertyGetter;
    private final Class coercionType;
    private HashSet<EventBean> nullKeys;
    private CompositeIndexEnterRemove next;

    public CompositeIndexEnterRemoveRange(EventType eventType, String rangeProp, Class coercionType) {
        this.propertyGetter = EventBeanUtility.getAssertPropertyGetter(eventType, rangeProp);
        this.coercionType = coercionType;
    }

    @Override
    public void setNext(CompositeIndexEnterRemove next) {
        this.next = next;
    }

    @Override
    public void getAll(HashSet<EventBean> result, Map parent) {
        if (this.next == null) {
            Map eventMap = parent;
            for (Map.Entry entry : eventMap.entrySet()) {
                result.addAll((Collection)entry.getValue());
            }
        } else {
            Map eventMap = parent;
            for (Map.Entry entry : eventMap.entrySet()) {
                this.next.getAll(result, (Map)entry.getValue());
            }
        }
        if (this.nullKeys != null) {
            result.addAll(this.nullKeys);
        }
    }

    @Override
    public void enter(EventBean event, Map parent) {
        Object sortable = this.propertyGetter.get(event);
        if (sortable == null) {
            if (this.nullKeys == null) {
                this.nullKeys = new HashSet();
            }
            this.nullKeys.add(event);
            return;
        }
        sortable = EventBeanUtility.coerce(sortable, this.coercionType);
        if (this.next == null) {
            Map eventMap = parent;
            HashSet<EventBean> events = (HashSet<EventBean>)eventMap.get(sortable);
            if (events == null) {
                events = new HashSet<EventBean>();
                eventMap.put(sortable, events);
            }
            events.add(event);
        } else {
            TreeMap innerIndex = (TreeMap)parent.get(sortable);
            if (innerIndex == null) {
                innerIndex = new TreeMap();
                parent.put(sortable, innerIndex);
            }
            this.next.enter(event, innerIndex);
        }
    }

    @Override
    public void remove(EventBean event, Map parent) {
        Object sortable = this.propertyGetter.get(event);
        if (sortable == null) {
            if (this.nullKeys != null) {
                this.nullKeys.remove(event);
            }
            return;
        }
        sortable = EventBeanUtility.coerce(sortable, this.coercionType);
        if (this.next == null) {
            Map eventMap = parent;
            if (eventMap == null) {
                return;
            }
            Set events = (Set)eventMap.get(sortable);
            if (events == null) {
                return;
            }
            if (!events.remove(event)) {
                return;
            }
            if (events.isEmpty()) {
                parent.remove(sortable);
            }
        } else {
            Map innerIndex = (Map)parent.get(sortable);
            if (innerIndex == null) {
                return;
            }
            this.next.remove(event, innerIndex);
            if (innerIndex.isEmpty()) {
                parent.remove(sortable);
            }
        }
    }
}

