/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.composite;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategy;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyGE;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyGT;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyLE;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyLT;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyRangeInverted;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyRangeNormal;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQuery;
import com.espertech.esper.epl.join.plan.QueryGraphRangeEnum;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeIn;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeRelOp;
import com.espertech.esper.epl.lookup.SubordPropRangeKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class CompositeIndexQueryRange
implements CompositeIndexQuery {
    private final CompositeAccessStrategy strategy;
    private CompositeIndexQuery next;

    public CompositeIndexQueryRange(boolean isNWOnTrigger, int lookupStream, int numStreams, SubordPropRangeKey subqRangeKey, Class coercionType) {
        QueryGraphValueEntryRange rangeProp = subqRangeKey.getRangeInfo();
        if (rangeProp.getType().isRange()) {
            QueryGraphValueEntryRangeIn in = (QueryGraphValueEntryRangeIn)rangeProp;
            ExprEvaluator start = in.getExprStart().getExprEvaluator();
            boolean includeStart = rangeProp.getType().isIncludeStart();
            ExprEvaluator end = in.getExprEnd().getExprEvaluator();
            boolean includeEnd = rangeProp.getType().isIncludeEnd();
            this.strategy = !rangeProp.getType().isRangeInverted() ? new CompositeAccessStrategyRangeNormal(isNWOnTrigger, lookupStream, numStreams, start, includeStart, end, includeEnd, coercionType, ((QueryGraphValueEntryRangeIn)rangeProp).isAllowRangeReversal()) : new CompositeAccessStrategyRangeInverted(isNWOnTrigger, lookupStream, numStreams, start, includeStart, end, includeEnd, coercionType);
        } else {
            QueryGraphValueEntryRangeRelOp relOp = (QueryGraphValueEntryRangeRelOp)rangeProp;
            ExprEvaluator key = relOp.getExpression().getExprEvaluator();
            if (rangeProp.getType() == QueryGraphRangeEnum.GREATER_OR_EQUAL) {
                this.strategy = new CompositeAccessStrategyGE(isNWOnTrigger, lookupStream, numStreams, key, coercionType);
            } else if (rangeProp.getType() == QueryGraphRangeEnum.GREATER) {
                this.strategy = new CompositeAccessStrategyGT(isNWOnTrigger, lookupStream, numStreams, key, coercionType);
            } else if (rangeProp.getType() == QueryGraphRangeEnum.LESS_OR_EQUAL) {
                this.strategy = new CompositeAccessStrategyLE(isNWOnTrigger, lookupStream, numStreams, key, coercionType);
            } else if (rangeProp.getType() == QueryGraphRangeEnum.LESS) {
                this.strategy = new CompositeAccessStrategyLT(isNWOnTrigger, lookupStream, numStreams, key, coercionType);
            } else {
                throw new IllegalArgumentException("Comparison operator " + (Object)((Object)rangeProp.getType()) + " not supported");
            }
        }
    }

    @Override
    public void add(EventBean event, Map parent, Set<EventBean> result) {
        this.strategy.lookup(event, parent, result, this.next, null);
    }

    @Override
    public void add(EventBean[] eventsPerStream, Map parent, Collection<EventBean> result) {
        this.strategy.lookup(eventsPerStream, parent, result, this.next, null);
    }

    @Override
    public Set<EventBean> get(EventBean event, Map parent, ExprEvaluatorContext context) {
        return this.strategy.lookup(event, parent, null, this.next, context);
    }

    @Override
    public Collection<EventBean> get(EventBean[] eventsPerStream, Map parent, ExprEvaluatorContext context) {
        return this.strategy.lookup(eventsPerStream, parent, null, this.next, context);
    }

    protected static Set<EventBean> handle(EventBean event, SortedMap sortedMapOne, SortedMap sortedMapTwo, Set<EventBean> result, CompositeIndexQuery next) {
        if (next == null) {
            if (result == null) {
                result = new HashSet<EventBean>();
            }
            CompositeIndexQueryRange.addResults(sortedMapOne, sortedMapTwo, result);
            return result;
        }
        if (result == null) {
            result = new HashSet<EventBean>();
        }
        SortedMap map = sortedMapOne;
        for (Map.Entry entry : map.entrySet()) {
            next.add(event, (Map)entry.getValue(), result);
        }
        if (sortedMapTwo != null) {
            map = sortedMapTwo;
            for (Map.Entry entry : map.entrySet()) {
                next.add(event, (Map)entry.getValue(), result);
            }
        }
        return result;
    }

    protected static Collection<EventBean> handle(EventBean[] eventsPerStream, SortedMap sortedMapOne, SortedMap sortedMapTwo, Collection<EventBean> result, CompositeIndexQuery next) {
        if (next == null) {
            if (result == null) {
                result = new HashSet<EventBean>();
            }
            CompositeIndexQueryRange.addResults(sortedMapOne, sortedMapTwo, result);
            return result;
        }
        if (result == null) {
            result = new HashSet<EventBean>();
        }
        SortedMap map = sortedMapOne;
        for (Map.Entry entry : map.entrySet()) {
            next.add(eventsPerStream, (Map)entry.getValue(), result);
        }
        if (sortedMapTwo != null) {
            map = sortedMapTwo;
            for (Map.Entry entry : map.entrySet()) {
                next.add(eventsPerStream, (Map)entry.getValue(), result);
            }
        }
        return result;
    }

    private static void addResults(SortedMap sortedMapOne, SortedMap sortedMapTwo, Collection<EventBean> result) {
        SortedMap map = sortedMapOne;
        for (Map.Entry entry : map.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        if (sortedMapTwo != null) {
            map = sortedMapTwo;
            for (Map.Entry entry : map.entrySet()) {
                result.addAll((Collection)entry.getValue());
            }
        }
    }

    @Override
    public void setNext(CompositeIndexQuery next) {
        this.next = next;
    }
}

