/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.sorted;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;

public abstract class SortedAccessStrategyRangeBase {
    protected ExprEvaluator start;
    protected boolean includeStart;
    protected ExprEvaluator end;
    protected boolean includeEnd;
    private final boolean isNWOnTrigger;
    private final EventBean[] events;
    private final int lookupStream;

    protected SortedAccessStrategyRangeBase(boolean isNWOnTrigger, int lookupStream, int numStreams, ExprEvaluator start, boolean includeStart, ExprEvaluator end, boolean includeEnd) {
        this.start = start;
        this.includeStart = includeStart;
        this.end = end;
        this.includeEnd = includeEnd;
        this.isNWOnTrigger = isNWOnTrigger;
        this.lookupStream = lookupStream;
        this.events = lookupStream != -1 ? new EventBean[lookupStream + 1] : new EventBean[numStreams + 1];
    }

    public Object evaluateLookupStart(EventBean event, ExprEvaluatorContext context) {
        this.events[this.lookupStream] = event;
        return this.start.evaluate(this.events, true, context);
    }

    public Object evaluateLookupEnd(EventBean event, ExprEvaluatorContext context) {
        this.events[this.lookupStream] = event;
        return this.end.evaluate(this.events, true, context);
    }

    public Object evaluatePerStreamStart(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        if (this.isNWOnTrigger) {
            return this.start.evaluate(eventsPerStream, true, context);
        }
        System.arraycopy(eventsPerStream, 0, this.events, 1, eventsPerStream.length);
        return this.start.evaluate(this.events, true, context);
    }

    public Object evaluatePerStreamEnd(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        if (this.isNWOnTrigger) {
            return this.end.evaluate(eventsPerStream, true, context);
        }
        System.arraycopy(eventsPerStream, 0, this.events, 1, eventsPerStream.length);
        return this.end.evaluate(this.events, true, context);
    }

    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " start=" + this.start.getClass().getSimpleName() + ", includeStart=" + this.includeStart + ", end=" + this.end.getClass().getSimpleName() + ", includeEnd=" + this.includeEnd;
    }
}

