/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.epl.datetime.eval.ExprDotNodeFilterAnalyzerDesc;
import com.espertech.esper.epl.expression.ExprAndNode;
import com.espertech.esper.epl.expression.ExprBetweenNode;
import com.espertech.esper.epl.expression.ExprDotNode;
import com.espertech.esper.epl.expression.ExprEqualsNode;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprRelationalOpNode;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.util.Eligibility;
import com.espertech.esper.epl.join.util.EligibilityDesc;
import com.espertech.esper.epl.join.util.EligibilityUtil;
import com.espertech.esper.epl.join.util.RangeFilterAnalyzer;

public class FilterExprAnalyzer {
    public static void analyze(ExprNode topNode, QueryGraph queryGraph, boolean isOuterJoin) {
        if (topNode instanceof ExprEqualsNode) {
            ExprEqualsNode equalsNode = (ExprEqualsNode)topNode;
            if (!equalsNode.isNotEquals()) {
                FilterExprAnalyzer.analyzeEqualsNode(equalsNode, queryGraph, isOuterJoin);
            }
        } else if (topNode instanceof ExprAndNode) {
            ExprAndNode andNode = (ExprAndNode)topNode;
            FilterExprAnalyzer.analyzeAndNode(andNode, queryGraph, isOuterJoin);
        } else if (topNode instanceof ExprBetweenNode) {
            ExprBetweenNode betweenNode = (ExprBetweenNode)topNode;
            FilterExprAnalyzer.analyzeBetweenNode(betweenNode, queryGraph);
        } else if (topNode instanceof ExprRelationalOpNode) {
            ExprRelationalOpNode relNode = (ExprRelationalOpNode)topNode;
            FilterExprAnalyzer.analyzeRelationalOpNode(relNode, queryGraph);
        } else if (topNode instanceof ExprDotNode && !isOuterJoin) {
            ExprDotNode dotNode = (ExprDotNode)topNode;
            FilterExprAnalyzer.analyzeDotNode(dotNode, queryGraph);
        }
    }

    private static void analyzeDotNode(ExprDotNode dotNode, QueryGraph queryGraph) {
        ExprDotNodeFilterAnalyzerDesc interval = dotNode.getExprDotNodeFilterAnalyzerDesc();
        if (interval == null) {
            return;
        }
        interval.apply(queryGraph);
    }

    private static void analyzeRelationalOpNode(ExprRelationalOpNode relNode, QueryGraph queryGraph) {
        ExprIdentNode identNode;
        if (relNode.getChildNodes().get(0) instanceof ExprIdentNode && relNode.getChildNodes().get(1) instanceof ExprIdentNode) {
            ExprIdentNode identNodeLeft = (ExprIdentNode)relNode.getChildNodes().get(0);
            ExprIdentNode identNodeRight = (ExprIdentNode)relNode.getChildNodes().get(1);
            if (identNodeLeft.getStreamId() != identNodeRight.getStreamId()) {
                queryGraph.addRelationalOpStrict(identNodeLeft.getStreamId(), identNodeLeft.getResolvedPropertyName(), identNodeLeft, identNodeRight.getStreamId(), identNodeRight.getResolvedPropertyName(), identNodeRight, relNode.getRelationalOpEnum());
            }
            return;
        }
        int indexedStream = -1;
        String indexedProp = null;
        ExprNode exprNodeNoIdent = null;
        if (relNode.getChildNodes().get(0) instanceof ExprIdentNode) {
            identNode = (ExprIdentNode)relNode.getChildNodes().get(0);
            indexedStream = identNode.getStreamId();
            indexedProp = identNode.getResolvedPropertyName();
            exprNodeNoIdent = relNode.getChildNodes().get(1);
        } else if (relNode.getChildNodes().get(1) instanceof ExprIdentNode) {
            identNode = (ExprIdentNode)relNode.getChildNodes().get(1);
            indexedStream = identNode.getStreamId();
            indexedProp = identNode.getResolvedPropertyName();
            exprNodeNoIdent = relNode.getChildNodes().get(0);
        }
        if (indexedStream == -1) {
            return;
        }
        EligibilityDesc eligibility = EligibilityUtil.verifyInputStream(exprNodeNoIdent, indexedStream);
        if (!eligibility.getEligibility().isEligible()) {
            return;
        }
        queryGraph.addRelationalOp(indexedStream, indexedProp, eligibility.getStreamNum(), exprNodeNoIdent, relNode.getRelationalOpEnum());
    }

    private static void analyzeBetweenNode(ExprBetweenNode betweenNode, QueryGraph queryGraph) {
        RangeFilterAnalyzer.apply(betweenNode.getChildNodes().get(0), betweenNode.getChildNodes().get(1), betweenNode.getChildNodes().get(2), betweenNode.isLowEndpointIncluded(), betweenNode.isHighEndpointIncluded(), betweenNode.isNotBetween(), queryGraph);
    }

    protected static void analyzeEqualsNode(ExprEqualsNode equalsNode, QueryGraph queryGraph, boolean isOuterJoin) {
        ExprIdentNode identNode;
        if (equalsNode.getChildNodes().get(0) instanceof ExprIdentNode && equalsNode.getChildNodes().get(1) instanceof ExprIdentNode) {
            ExprIdentNode identNodeLeft = (ExprIdentNode)equalsNode.getChildNodes().get(0);
            ExprIdentNode identNodeRight = (ExprIdentNode)equalsNode.getChildNodes().get(1);
            if (identNodeLeft.getStreamId() != identNodeRight.getStreamId()) {
                queryGraph.addStrictEquals(identNodeLeft.getStreamId(), identNodeLeft.getResolvedPropertyName(), identNodeLeft, identNodeRight.getStreamId(), identNodeRight.getResolvedPropertyName(), identNodeRight);
            }
            return;
        }
        if (isOuterJoin) {
            return;
        }
        int indexedStream = -1;
        String indexedProp = null;
        ExprNode exprNodeNoIdent = null;
        if (equalsNode.getChildNodes().get(0) instanceof ExprIdentNode) {
            identNode = (ExprIdentNode)equalsNode.getChildNodes().get(0);
            indexedStream = identNode.getStreamId();
            indexedProp = identNode.getResolvedPropertyName();
            exprNodeNoIdent = equalsNode.getChildNodes().get(1);
        } else if (equalsNode.getChildNodes().get(1) instanceof ExprIdentNode) {
            identNode = (ExprIdentNode)equalsNode.getChildNodes().get(1);
            indexedStream = identNode.getStreamId();
            indexedProp = identNode.getResolvedPropertyName();
            exprNodeNoIdent = equalsNode.getChildNodes().get(0);
        }
        if (indexedStream == -1) {
            return;
        }
        EligibilityDesc eligibility = EligibilityUtil.verifyInputStream(exprNodeNoIdent, indexedStream);
        if (!eligibility.getEligibility().isEligible()) {
            return;
        }
        if (eligibility.getEligibility() == Eligibility.REQUIRE_NONE) {
            queryGraph.addUnkeyedExpression(indexedStream, indexedProp, exprNodeNoIdent);
        } else {
            queryGraph.addKeyedExpression(indexedStream, indexedProp, eligibility.getStreamNum(), exprNodeNoIdent);
        }
    }

    protected static void analyzeAndNode(ExprAndNode andNode, QueryGraph queryGraph, boolean isOuterJoin) {
        for (ExprNode childNode : andNode.getChildNodes()) {
            FilterExprAnalyzer.analyze(childNode, queryGraph, isOuterJoin);
        }
    }
}

