/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.collection.InterchangeablePair;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.type.OuterJoinType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InnerJoinGraph {
    private final int numStreams;
    private final boolean isAllInnerJoin;
    private final Set<InterchangeablePair<Integer, Integer>> innerJoins;

    public InnerJoinGraph(int numStreams, Set<InterchangeablePair<Integer, Integer>> innerJoins) {
        this.numStreams = numStreams;
        this.isAllInnerJoin = false;
        this.innerJoins = innerJoins;
    }

    public InnerJoinGraph(int numStreams, boolean isAllInnerJoin) {
        this.numStreams = numStreams;
        this.isAllInnerJoin = isAllInnerJoin;
        this.innerJoins = null;
    }

    public boolean isAllInnerJoin() {
        return this.isAllInnerJoin;
    }

    public boolean isEmpty() {
        if (this.isAllInnerJoin) {
            return false;
        }
        return this.innerJoins.isEmpty();
    }

    public boolean hasInnerJoin(int toStream) {
        if (this.isAllInnerJoin) {
            return true;
        }
        boolean hasInnerJoin = false;
        for (InterchangeablePair<Integer, Integer> pair : this.innerJoins) {
            if (pair.getFirst() == toStream) {
                hasInnerJoin = true;
            }
            if (pair.getSecond() != toStream) continue;
            hasInnerJoin = true;
        }
        return hasInnerJoin;
    }

    public static InnerJoinGraph graphInnerJoins(int numStreams, List<OuterJoinDesc> outerJoinDescList) {
        if (outerJoinDescList.size() + 1 != numStreams) {
            throw new IllegalArgumentException("Number of outer join descriptors and number of streams not matching up");
        }
        HashSet<InterchangeablePair<Integer, Integer>> graph = new HashSet<InterchangeablePair<Integer, Integer>>();
        boolean allInnerJoin = true;
        for (int i = 0; i < outerJoinDescList.size(); ++i) {
            OuterJoinDesc desc = outerJoinDescList.get(i);
            int streamMax = i + 1;
            int streamOne = desc.getLeftNode().getStreamId();
            int streamTwo = desc.getRightNode().getStreamId();
            if (streamOne > streamMax || streamTwo > streamMax || streamOne == streamTwo) {
                throw new IllegalArgumentException("Outer join descriptors reference future streams, or same streams");
            }
            if (desc.getOuterJoinType() == OuterJoinType.INNER) {
                graph.add(new InterchangeablePair<Integer, Integer>(streamOne, streamTwo));
                continue;
            }
            allInnerJoin = false;
        }
        if (allInnerJoin) {
            return new InnerJoinGraph(numStreams, true);
        }
        return new InnerJoinGraph(numStreams, graph);
    }

    public void addRequiredStreams(int streamNum, Set<Integer> requiredStreams, Set<Integer> completedStreams) {
        if (this.isAllInnerJoin) {
            for (int i = 0; i < this.numStreams; ++i) {
                if (completedStreams.contains(i)) continue;
                requiredStreams.add(i);
            }
            return;
        }
        for (InterchangeablePair<Integer, Integer> pair : this.innerJoins) {
            if (pair.getFirst() == streamNum && !completedStreams.contains(pair.getSecond())) {
                requiredStreams.add(pair.getSecond());
            }
            if (pair.getSecond() != streamNum || completedStreams.contains(pair.getFirst())) continue;
            requiredStreams.add(pair.getFirst());
        }
    }
}

