/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.assemble.AssemblyStrategyTreeBuilder;
import com.espertech.esper.epl.join.assemble.BaseAssemblyNode;
import com.espertech.esper.epl.join.base.HistoricalViewableDesc;
import com.espertech.esper.epl.join.plan.HistoricalDataPlanNode;
import com.espertech.esper.epl.join.plan.InnerJoinGraph;
import com.espertech.esper.epl.join.plan.LookupInstructionPlan;
import com.espertech.esper.epl.join.plan.LookupInstructionQueryPlanNode;
import com.espertech.esper.epl.join.plan.NStreamQueryPlanBuilder;
import com.espertech.esper.epl.join.plan.OuterInnerDirectionalGraph;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryPlan;
import com.espertech.esper.epl.join.plan.QueryPlanIndex;
import com.espertech.esper.epl.join.plan.QueryPlanIndexBuilder;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.plan.QueryPlanNodeNoOp;
import com.espertech.esper.epl.join.plan.TableLookupPlan;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.DependencyGraph;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NStreamOuterQueryPlanBuilder {
    private static Log log = LogFactory.getLog(NStreamOuterQueryPlanBuilder.class);

    protected static QueryPlan build(QueryGraph queryGraph, List<OuterJoinDesc> outerJoinDescList, String[] streamNames, EventType[] typesPerStream, HistoricalViewableDesc historicalViewableDesc, DependencyGraph dependencyGraph, HistoricalStreamIndexList[] historicalStreamIndexLists, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        InnerJoinGraph innerJoinGraph;
        OuterInnerDirectionalGraph outerInnerGraph;
        if (log.isDebugEnabled()) {
            log.debug((Object)(".build queryGraph=" + queryGraph));
        }
        int numStreams = queryGraph.getNumStreams();
        QueryPlanNode[] planNodeSpecs = new QueryPlanNode[numStreams];
        QueryPlanIndex[] indexSpecs = QueryPlanIndexBuilder.buildIndexSpec(queryGraph, typesPerStream);
        if (log.isDebugEnabled()) {
            log.debug((Object)(".build Index build completed, indexes=" + QueryPlanIndex.print(indexSpecs)));
        }
        if (historicalViewableDesc.isHasHistorical()) {
            for (int i = 0; i < historicalViewableDesc.getHistorical().length; ++i) {
                if (!historicalViewableDesc.getHistorical()[i]) continue;
                indexSpecs[i] = null;
            }
        }
        if (!outerJoinDescList.isEmpty()) {
            outerInnerGraph = NStreamOuterQueryPlanBuilder.graphOuterJoins(numStreams, outerJoinDescList);
            innerJoinGraph = InnerJoinGraph.graphInnerJoins(numStreams, outerJoinDescList);
        } else {
            outerInnerGraph = new OuterInnerDirectionalGraph(numStreams);
            innerJoinGraph = new InnerJoinGraph(numStreams, true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(".build directional graph=" + outerInnerGraph.print()));
        }
        for (int streamNo = 0; streamNo < numStreams; ++streamNo) {
            if (historicalViewableDesc.getHistorical()[streamNo] && dependencyGraph.hasDependency(streamNo)) {
                planNodeSpecs[streamNo] = new QueryPlanNodeNoOp();
                continue;
            }
            QueryPlanNode queryPlanNode = NStreamOuterQueryPlanBuilder.buildPlanNode(numStreams, streamNo, streamNames, queryGraph, outerInnerGraph, outerJoinDescList, innerJoinGraph, indexSpecs, typesPerStream, historicalViewableDesc.getHistorical(), dependencyGraph, historicalStreamIndexLists, exprEvaluatorContext);
            if (log.isDebugEnabled()) {
                log.debug((Object)(".build spec for stream '" + streamNames[streamNo] + "' number " + streamNo + " is " + queryPlanNode));
            }
            planNodeSpecs[streamNo] = queryPlanNode;
        }
        QueryPlan queryPlan = new QueryPlan(indexSpecs, planNodeSpecs);
        if (log.isDebugEnabled()) {
            log.debug((Object)(".build query plan=" + queryPlan.toString()));
        }
        return queryPlan;
    }

    private static QueryPlanNode buildPlanNode(int numStreams, int streamNo, String[] streamNames, QueryGraph queryGraph, OuterInnerDirectionalGraph outerInnerGraph, List<OuterJoinDesc> outerJoinDescList, InnerJoinGraph innerJoinGraph, QueryPlanIndex[] indexSpecs, EventType[] typesPerStream, boolean[] ishistorical, DependencyGraph dependencyGraph, HistoricalStreamIndexList[] historicalStreamIndexLists, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        LinkedHashMap<Integer, int[]> substreamsPerStream = new LinkedHashMap<Integer, int[]>();
        boolean[] requiredPerStream = new boolean[numStreams];
        HashSet<Integer> completedStreams = new HashSet<Integer>();
        Stack<Integer> streamCallStack = new Stack<Integer>();
        streamCallStack.push(streamNo);
        if (innerJoinGraph.isAllInnerJoin()) {
            Arrays.fill(requiredPerStream, true);
            NStreamOuterQueryPlanBuilder.recursiveBuildInnerJoin(streamNo, streamCallStack, queryGraph, completedStreams, substreamsPerStream, dependencyGraph);
            NStreamQueryPlanBuilder.BestChainResult bestChain = NStreamQueryPlanBuilder.computeBestPath(streamNo, queryGraph, dependencyGraph);
            NStreamOuterQueryPlanBuilder.addNotYetNavigated(streamNo, numStreams, substreamsPerStream, bestChain);
        } else {
            NStreamOuterQueryPlanBuilder.recursiveBuild(streamNo, streamCallStack, queryGraph, outerInnerGraph, innerJoinGraph, completedStreams, substreamsPerStream, requiredPerStream, dependencyGraph);
        }
        NStreamOuterQueryPlanBuilder.verifyJoinedPerStream(streamNo, substreamsPerStream);
        List<LookupInstructionPlan> lookupInstructions = NStreamOuterQueryPlanBuilder.buildLookupInstructions(streamNo, substreamsPerStream, requiredPerStream, streamNames, queryGraph, indexSpecs, typesPerStream, outerJoinDescList, ishistorical, historicalStreamIndexLists, exprEvaluatorContext);
        BaseAssemblyNode assemblyTopNode = AssemblyStrategyTreeBuilder.build(streamNo, substreamsPerStream, requiredPerStream);
        List<BaseAssemblyNode> assemblyInstructions = BaseAssemblyNode.getDescendentNodesBottomUp(assemblyTopNode);
        return new LookupInstructionQueryPlanNode(streamNo, streamNames[streamNo], numStreams, requiredPerStream, lookupInstructions, assemblyInstructions);
    }

    private static void addNotYetNavigated(int streamNo, int numStreams, LinkedHashMap<Integer, int[]> substreamsPerStream, NStreamQueryPlanBuilder.BestChainResult bestChain) {
        HashSet<Integer> streams = new HashSet<Integer>();
        streams.add(streamNo);
        NStreamOuterQueryPlanBuilder.recursiveAdd(streamNo, streamNo, substreamsPerStream, streams, false);
        if (streams.size() == numStreams) {
            return;
        }
        int previous = streamNo;
        for (int stream : bestChain.getChain()) {
            if (streams.contains(stream)) {
                previous = stream;
                continue;
            }
            int[] substreams = substreamsPerStream.get(previous);
            if (substreams == null) {
                substreams = new int[]{};
            }
            int[] added = CollectionUtil.addValue(substreams, stream);
            substreamsPerStream.put(previous, added);
            if (!substreamsPerStream.containsKey(stream)) {
                substreamsPerStream.put(stream, new int[0]);
            }
            previous = stream;
        }
    }

    private static List<LookupInstructionPlan> buildLookupInstructions(int rootStreamNum, LinkedHashMap<Integer, int[]> substreamsPerStream, boolean[] requiredPerStream, String[] streamNames, QueryGraph queryGraph, QueryPlanIndex[] indexSpecs, EventType[] typesPerStream, List<OuterJoinDesc> outerJoinDescList, boolean[] isHistorical, HistoricalStreamIndexList[] historicalStreamIndexLists, ExprEvaluatorContext exprEvaluatorContext) {
        LinkedList<LookupInstructionPlan> result = new LinkedList<LookupInstructionPlan>();
        for (int fromStream : substreamsPerStream.keySet()) {
            int[] substreams = substreamsPerStream.get(fromStream);
            if (substreams.length == 0) continue;
            TableLookupPlan[] plans = new TableLookupPlan[substreams.length];
            HistoricalDataPlanNode[] historicalPlans = new HistoricalDataPlanNode[substreams.length];
            for (int i = 0; i < substreams.length; ++i) {
                int toStream = substreams[i];
                if (isHistorical[toStream]) {
                    ExprNode outerJoinExpr = null;
                    if (!outerJoinDescList.isEmpty()) {
                        OuterJoinDesc outerJoinDesc = toStream == 0 ? outerJoinDescList.get(0) : outerJoinDescList.get(toStream - 1);
                        outerJoinExpr = outerJoinDesc.makeExprNode(exprEvaluatorContext);
                    }
                    if (historicalStreamIndexLists[toStream] == null) {
                        historicalStreamIndexLists[toStream] = new HistoricalStreamIndexList(toStream, typesPerStream, queryGraph);
                    }
                    historicalStreamIndexLists[toStream].addIndex(fromStream);
                    historicalPlans[i] = new HistoricalDataPlanNode(toStream, rootStreamNum, fromStream, typesPerStream.length, outerJoinExpr);
                    continue;
                }
                plans[i] = NStreamQueryPlanBuilder.createLookupPlan(queryGraph, fromStream, toStream, indexSpecs[toStream], typesPerStream);
            }
            String fromStreamName = streamNames[fromStream];
            LookupInstructionPlan instruction = new LookupInstructionPlan(fromStream, fromStreamName, substreams, plans, historicalPlans, requiredPerStream);
            result.add(instruction);
        }
        return result;
    }

    protected static void recursiveBuild(int streamNum, Stack<Integer> streamCallStack, QueryGraph queryGraph, OuterInnerDirectionalGraph outerInnerGraph, InnerJoinGraph innerJoinGraph, Set<Integer> completedStreams, LinkedHashMap<Integer, int[]> substreamsPerStream, boolean[] requiredPerStream, DependencyGraph dependencyGraph) throws ExprValidationException {
        completedStreams.add(streamNum);
        if (dependencyGraph.hasDependency(streamNum)) {
            Set<Integer> dependencies = dependencyGraph.getDependenciesForStream(streamNum);
            for (Integer dependentStream : dependencies) {
                if (streamCallStack.contains(dependentStream)) continue;
                throw new ExprValidationException("Historical stream " + streamNum + " parameter dependency originating in stream " + dependentStream + " cannot or may not be satisfied by the join");
            }
        }
        Set<Integer> navigableStreams = queryGraph.getNavigableStreams(streamNum);
        navigableStreams.removeAll(completedStreams);
        Set<Integer> requiredStreams = NStreamOuterQueryPlanBuilder.getOuterStreams(streamNum, navigableStreams, outerInnerGraph);
        innerJoinGraph.addRequiredStreams(streamNum, requiredStreams, completedStreams);
        Set<Integer> optionalStreams = NStreamOuterQueryPlanBuilder.getInnerStreams(streamNum, navigableStreams, outerInnerGraph, innerJoinGraph, completedStreams);
        requiredStreams.removeAll(optionalStreams);
        if (navigableStreams.isEmpty()) {
            substreamsPerStream.put(streamNum, new int[0]);
            return;
        }
        int[] substreams = new int[requiredStreams.size() + optionalStreams.size()];
        substreamsPerStream.put(streamNum, substreams);
        int count = 0;
        for (int stream : requiredStreams) {
            substreams[count++] = stream;
            requiredPerStream[stream] = true;
        }
        for (int stream : optionalStreams) {
            substreams[count++] = stream;
        }
        for (int stream : requiredStreams) {
            completedStreams.add(stream);
        }
        for (int stream : requiredStreams) {
            streamCallStack.push(stream);
            NStreamOuterQueryPlanBuilder.recursiveBuild(stream, streamCallStack, queryGraph, outerInnerGraph, innerJoinGraph, completedStreams, substreamsPerStream, requiredPerStream, dependencyGraph);
            streamCallStack.pop();
        }
        for (int stream : optionalStreams) {
            streamCallStack.push(stream);
            NStreamOuterQueryPlanBuilder.recursiveBuild(stream, streamCallStack, queryGraph, outerInnerGraph, innerJoinGraph, completedStreams, substreamsPerStream, requiredPerStream, dependencyGraph);
            streamCallStack.pop();
        }
    }

    protected static void recursiveBuildInnerJoin(int streamNum, Stack<Integer> streamCallStack, QueryGraph queryGraph, Set<Integer> completedStreams, LinkedHashMap<Integer, int[]> substreamsPerStream, DependencyGraph dependencyGraph) throws ExprValidationException {
        Integer[] navigableStreamArr;
        completedStreams.add(streamNum);
        if (dependencyGraph.hasDependency(streamNum)) {
            Set<Integer> dependencies = dependencyGraph.getDependenciesForStream(streamNum);
            for (Integer dependentStream : dependencies) {
                if (streamCallStack.contains(dependentStream)) continue;
                throw new ExprValidationException("Historical stream " + streamNum + " parameter dependency originating in stream " + dependentStream + " cannot or may not be satisfied by the join");
            }
        }
        Set<Integer> navigableStreams = queryGraph.getNavigableStreams(streamNum);
        Integer[] arr$ = navigableStreamArr = navigableStreams.toArray(new Integer[navigableStreams.size()]);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int navigableStream = arr$[i$];
            if (!dependencyGraph.hasUnsatisfiedDependency(navigableStream, completedStreams)) continue;
            navigableStreams.remove(navigableStream);
        }
        navigableStreams.removeAll(completedStreams);
        if (navigableStreams.isEmpty()) {
            substreamsPerStream.put(streamNum, new int[0]);
            return;
        }
        int[] substreams = new int[navigableStreams.size()];
        substreamsPerStream.put(streamNum, substreams);
        int count = 0;
        for (int stream : navigableStreams) {
            substreams[count++] = stream;
            completedStreams.add(stream);
        }
        for (int stream : navigableStreams) {
            streamCallStack.push(stream);
            NStreamOuterQueryPlanBuilder.recursiveBuildInnerJoin(stream, streamCallStack, queryGraph, completedStreams, substreamsPerStream, dependencyGraph);
            streamCallStack.pop();
        }
    }

    private static Set<Integer> getInnerStreams(int fromStream, Set<Integer> toStreams, OuterInnerDirectionalGraph outerInnerGraph, InnerJoinGraph innerJoinGraph, Set<Integer> completedStreams) {
        HashSet<Integer> innerStreams = new HashSet<Integer>();
        for (int toStream : toStreams) {
            if (!outerInnerGraph.isInner(fromStream, toStream)) continue;
            boolean hasInnerJoin = false;
            if (!innerJoinGraph.isEmpty()) {
                HashSet<Integer> doNotUseStreams = new HashSet<Integer>(completedStreams);
                completedStreams.add(fromStream);
                hasInnerJoin = NStreamOuterQueryPlanBuilder.recursiveHasInnerJoin(toStream, outerInnerGraph, innerJoinGraph, doNotUseStreams);
            }
            if (hasInnerJoin) continue;
            innerStreams.add(toStream);
        }
        return innerStreams;
    }

    private static boolean recursiveHasInnerJoin(int toStream, OuterInnerDirectionalGraph outerInnerGraph, InnerJoinGraph innerJoinGraph, Set<Integer> completedStreams) {
        Set<Integer> outerToToStream;
        boolean hasInnerJoin = innerJoinGraph.hasInnerJoin(toStream);
        if (hasInnerJoin) {
            return true;
        }
        Set<Integer> innerToToStream = outerInnerGraph.getInner(toStream);
        if (innerToToStream != null) {
            for (int nextStream : innerToToStream) {
                if (completedStreams.contains(nextStream)) continue;
                HashSet<Integer> notConsider = new HashSet<Integer>(completedStreams);
                notConsider.add(toStream);
                boolean result = NStreamOuterQueryPlanBuilder.recursiveHasInnerJoin(nextStream, outerInnerGraph, innerJoinGraph, notConsider);
                if (!result) continue;
                return true;
            }
        }
        if ((outerToToStream = outerInnerGraph.getOuter(toStream)) != null) {
            for (int nextStream : outerToToStream) {
                if (completedStreams.contains(nextStream)) continue;
                HashSet<Integer> notConsider = new HashSet<Integer>(completedStreams);
                notConsider.add(toStream);
                boolean result = NStreamOuterQueryPlanBuilder.recursiveHasInnerJoin(nextStream, outerInnerGraph, innerJoinGraph, notConsider);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<Integer> getOuterStreams(int fromStream, Set<Integer> toStreams, OuterInnerDirectionalGraph outerInnerGraph) {
        HashSet<Integer> outerStreams = new HashSet<Integer>();
        for (int toStream : toStreams) {
            if (!outerInnerGraph.isOuter(toStream, fromStream)) continue;
            outerStreams.add(toStream);
        }
        return outerStreams;
    }

    protected static OuterInnerDirectionalGraph graphOuterJoins(int numStreams, List<OuterJoinDesc> outerJoinDescList) {
        if (outerJoinDescList.size() + 1 != numStreams) {
            throw new IllegalArgumentException("Number of outer join descriptors and number of streams not matching up");
        }
        OuterInnerDirectionalGraph graph = new OuterInnerDirectionalGraph(numStreams);
        for (int i = 0; i < outerJoinDescList.size(); ++i) {
            OuterJoinDesc desc = outerJoinDescList.get(i);
            int streamMax = i + 1;
            int streamOne = desc.getLeftNode().getStreamId();
            int streamTwo = desc.getRightNode().getStreamId();
            if (streamOne > streamMax || streamTwo > streamMax || streamOne == streamTwo) {
                throw new IllegalArgumentException("Outer join descriptors reference future streams, or same streams");
            }
            int lowerStream = streamOne;
            int higherStream = streamTwo;
            if (streamOne > streamTwo) {
                lowerStream = streamTwo;
                higherStream = streamOne;
            }
            if (desc.getOuterJoinType() == OuterJoinType.FULL) {
                graph.add(streamOne, streamTwo);
                graph.add(streamTwo, streamOne);
                continue;
            }
            if (desc.getOuterJoinType() == OuterJoinType.LEFT) {
                graph.add(lowerStream, higherStream);
                continue;
            }
            if (desc.getOuterJoinType() == OuterJoinType.RIGHT) {
                graph.add(higherStream, lowerStream);
                continue;
            }
            if (desc.getOuterJoinType() == OuterJoinType.INNER) continue;
            throw new IllegalArgumentException("Outer join descriptors join type not handled, type=" + (Object)((Object)desc.getOuterJoinType()));
        }
        return graph;
    }

    public static void verifyJoinedPerStream(int rootStream, Map<Integer, int[]> streamsJoinedPerStream) {
        HashSet<Integer> streams = new HashSet<Integer>();
        streams.add(rootStream);
        NStreamOuterQueryPlanBuilder.recursiveAdd(rootStream, rootStream, streamsJoinedPerStream, streams, true);
        if (streams.size() != streamsJoinedPerStream.size()) {
            throw new IllegalArgumentException("Not all streams found, streamsJoinedPerStream=" + NStreamOuterQueryPlanBuilder.print(streamsJoinedPerStream));
        }
    }

    private static void recursiveAdd(int validatedStream, int currentStream, Map<Integer, int[]> streamsJoinedPerStream, Set<Integer> streams, boolean verify) {
        if (currentStream >= streamsJoinedPerStream.size() && verify) {
            throw new IllegalArgumentException("Error in stream " + currentStream + " streamsJoinedPerStream=" + NStreamOuterQueryPlanBuilder.print(streamsJoinedPerStream));
        }
        int[] joinedStreams = streamsJoinedPerStream.get(currentStream);
        for (int i = 0; i < joinedStreams.length; ++i) {
            int addStream = joinedStreams[i];
            if (streams.contains(addStream)) {
                throw new IllegalArgumentException("Stream " + addStream + " found twice when validating " + validatedStream);
            }
            streams.add(addStream);
            NStreamOuterQueryPlanBuilder.recursiveAdd(validatedStream, addStream, streamsJoinedPerStream, streams, verify);
        }
    }

    public static String print(Map<Integer, int[]> streamsJoinedPerStream) {
        StringWriter buf = new StringWriter();
        PrintWriter printer = new PrintWriter(buf);
        for (int stream : streamsJoinedPerStream.keySet()) {
            int[] substreams = streamsJoinedPerStream.get(stream);
            printer.println("stream " + stream + " : " + Arrays.toString(substreams));
        }
        return buf.toString();
    }
}

