/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprIdentNodeImpl;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.join.plan.QueryGraphKey;
import com.espertech.esper.epl.join.plan.QueryGraphRangeEnum;
import com.espertech.esper.epl.join.plan.QueryGraphValue;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairHashKeyIndex;
import com.espertech.esper.type.RelationalOpEnum;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QueryGraph {
    private final int numStreams;
    private final Map<QueryGraphKey, QueryGraphValue> streamJoinMap;

    public QueryGraph(int numStreams) {
        this.numStreams = numStreams;
        this.streamJoinMap = new HashMap<QueryGraphKey, QueryGraphValue>();
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public boolean addStrictEquals(int streamLeft, String propertyLeft, ExprIdentNode nodeLeft, int streamRight, String propertyRight, ExprIdentNode nodeRight) {
        this.check(streamLeft, streamRight);
        if (propertyLeft == null || propertyRight == null) {
            throw new IllegalArgumentException("Null property names supplied");
        }
        if (streamLeft == streamRight) {
            throw new IllegalArgumentException("Streams supplied are the same");
        }
        boolean addedLeft = this.addInteral(streamLeft, propertyLeft, nodeLeft, streamRight, propertyRight, nodeRight);
        boolean addedRight = this.addInteral(streamRight, propertyRight, nodeRight, streamLeft, propertyLeft, nodeLeft);
        return addedLeft || addedRight;
    }

    private boolean addInteral(int streamLookup, String propertyLookup, ExprIdentNode propertyLookupNode, int streamIndexed, String propertyIndexed, ExprIdentNode propertyIndexedNode) {
        QueryGraphKey key = new QueryGraphKey(streamLookup, streamIndexed);
        QueryGraphValue value = this.streamJoinMap.get(key);
        if (value == null) {
            value = new QueryGraphValue();
            this.streamJoinMap.put(key, value);
        }
        return value.addStrictCompare(propertyLookup, propertyLookupNode, propertyIndexed, propertyIndexedNode);
    }

    public boolean isNavigableAtAll(int streamFrom, int streamTo) {
        QueryGraphKey key = new QueryGraphKey(streamFrom, streamTo);
        QueryGraphValue value = this.streamJoinMap.get(key);
        if (value == null) {
            return false;
        }
        return !value.getEntries().isEmpty();
    }

    public Set<Integer> getNavigableStreams(int streamFrom) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 0; i < this.numStreams; ++i) {
            if (!this.isNavigableAtAll(streamFrom, i)) continue;
            result.add(i);
        }
        return result;
    }

    private QueryGraphValue getCreateValue(int streamKey, int streamValue) {
        this.check(streamValue, streamKey);
        QueryGraphKey key = new QueryGraphKey(streamKey, streamValue);
        QueryGraphValue value = this.streamJoinMap.get(key);
        if (value == null) {
            value = new QueryGraphValue();
            this.streamJoinMap.put(key, value);
        }
        return value;
    }

    public QueryGraphValue getGraphValue(int streamLookup, int streamIndexed) {
        QueryGraphKey key = new QueryGraphKey(streamLookup, streamIndexed);
        QueryGraphValue value = this.streamJoinMap.get(key);
        if (value != null) {
            return value;
        }
        return new QueryGraphValue();
    }

    public static void fillEquivalentNav(EventType[] typesPerStream, QueryGraph queryGraph) {
        boolean addedEquivalency;
        do {
            addedEquivalency = false;
            for (int lookupStream = 0; lookupStream < queryGraph.numStreams; ++lookupStream) {
                for (int indexedStream = 0; indexedStream < queryGraph.numStreams; ++indexedStream) {
                    boolean added;
                    if (lookupStream == indexedStream || !(added = QueryGraph.fillEquivalentNav(typesPerStream, queryGraph, lookupStream, indexedStream))) continue;
                    addedEquivalency = true;
                }
            }
        } while (addedEquivalency);
    }

    private static boolean fillEquivalentNav(EventType[] typesPerStream, QueryGraph queryGraph, int lookupStream, int indexedStream) {
        boolean addedEquivalency = false;
        QueryGraphValue value = queryGraph.getGraphValue(lookupStream, indexedStream);
        if (value.getEntries().isEmpty()) {
            return false;
        }
        QueryGraphValuePairHashKeyIndex hashKeys = value.getHashKeyProps();
        String[] strictKeyProps = hashKeys.getStrictKeys();
        String[] indexProps = hashKeys.getIndexed();
        if (strictKeyProps.length == 0) {
            return false;
        }
        if (strictKeyProps.length != indexProps.length) {
            throw new IllegalStateException("Unexpected key and index property number mismatch");
        }
        for (int i = 0; i < strictKeyProps.length; ++i) {
            boolean added;
            if (strictKeyProps[i] == null || !(added = QueryGraph.fillEquivalentNav(typesPerStream, queryGraph, lookupStream, strictKeyProps[i], indexedStream, indexProps[i]))) continue;
            addedEquivalency = true;
        }
        return addedEquivalency;
    }

    private static boolean fillEquivalentNav(EventType[] typesPerStream, QueryGraph queryGraph, int lookupStream, String keyProp, int indexedStream, String indexProp) {
        boolean addedEquivalency = false;
        for (int otherStream = 0; otherStream < queryGraph.numStreams; ++otherStream) {
            ExprIdentNodeImpl identNodeOther;
            ExprIdentNodeImpl identNodeLookup;
            boolean added;
            if (otherStream == lookupStream || otherStream == indexedStream) continue;
            QueryGraphValue value = queryGraph.getGraphValue(otherStream, indexedStream);
            QueryGraphValuePairHashKeyIndex hashKeys = value.getHashKeyProps();
            String[] otherStrictKeyProps = hashKeys.getStrictKeys();
            String[] otherIndexProps = hashKeys.getIndexed();
            int otherPropertyNum = -1;
            if (otherIndexProps == null) continue;
            for (int i = 0; i < otherIndexProps.length; ++i) {
                if (!otherIndexProps[i].equals(indexProp)) continue;
                otherPropertyNum = i;
                break;
            }
            if (otherPropertyNum == -1 || otherStrictKeyProps[otherPropertyNum] == null || !(added = queryGraph.addStrictEquals(lookupStream, keyProp, identNodeLookup = new ExprIdentNodeImpl(typesPerStream[lookupStream], keyProp, lookupStream), otherStream, otherStrictKeyProps[otherPropertyNum], identNodeOther = new ExprIdentNodeImpl(typesPerStream[otherStream], otherStrictKeyProps[otherPropertyNum], otherStream)))) continue;
            addedEquivalency = true;
        }
        return addedEquivalency;
    }

    public String toString() {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        int count = 0;
        for (Map.Entry<QueryGraphKey, QueryGraphValue> entry : this.streamJoinMap.entrySet()) {
            writer.println("Entry " + ++count + ": key=" + entry.getKey());
            writer.println("  value=" + entry.getValue());
        }
        return buf.toString();
    }

    public void addRangeStrict(int streamNumStart, String propertyStart, ExprIdentNode propertyStartExpr, int streamNumEnd, String propertyEnd, ExprIdentNode propertyEndExpr, int streamNumValue, String propertyValue, ExprIdentNode propertyValueExpr, boolean includeStart, boolean includeEnd, boolean isInverted) {
        this.check(streamNumStart, streamNumValue);
        this.check(streamNumEnd, streamNumValue);
        if (streamNumStart == streamNumEnd && streamNumStart != streamNumValue) {
            QueryGraphRangeEnum rangeOp = QueryGraphRangeEnum.getRangeOp(includeStart, includeEnd, isInverted);
            QueryGraphValue valueLeft = this.getCreateValue(streamNumStart, streamNumValue);
            valueLeft.addRange(rangeOp, propertyStartExpr, propertyEndExpr, propertyValue);
            QueryGraphValue valueRight = this.getCreateValue(streamNumValue, streamNumStart);
            valueRight.addRelOp(propertyValueExpr, QueryGraphRangeEnum.GREATER_OR_EQUAL, propertyEnd, false);
            valueRight.addRelOp(propertyValueExpr, QueryGraphRangeEnum.LESS_OR_EQUAL, propertyStart, false);
        } else {
            if (streamNumValue != streamNumStart) {
                QueryGraphValue valueStart = this.getCreateValue(streamNumStart, streamNumValue);
                valueStart.addRelOp(propertyStartExpr, QueryGraphRangeEnum.GREATER_OR_EQUAL, propertyValue, true);
                QueryGraphValue valueStartReversed = this.getCreateValue(streamNumValue, streamNumStart);
                valueStartReversed.addRelOp(propertyValueExpr, QueryGraphRangeEnum.LESS_OR_EQUAL, propertyStart, true);
            }
            if (streamNumValue != streamNumEnd) {
                QueryGraphValue valueEnd = this.getCreateValue(streamNumEnd, streamNumValue);
                valueEnd.addRelOp(propertyEndExpr, QueryGraphRangeEnum.LESS_OR_EQUAL, propertyValue, true);
                QueryGraphValue valueEndReversed = this.getCreateValue(streamNumValue, streamNumEnd);
                valueEndReversed.addRelOp(propertyValueExpr, QueryGraphRangeEnum.GREATER_OR_EQUAL, propertyEnd, true);
            }
        }
    }

    public void addRelationalOpStrict(int streamIdLeft, String propertyLeft, ExprNode propertyLeftExpr, int streamIdRight, String propertyRight, ExprNode propertyRightExpr, RelationalOpEnum relationalOpEnum) {
        this.check(streamIdLeft, streamIdRight);
        QueryGraphValue valueLeft = this.getCreateValue(streamIdLeft, streamIdRight);
        valueLeft.addRelOp(propertyLeftExpr, QueryGraphRangeEnum.mapFrom(relationalOpEnum.reversed()), propertyRight, false);
        QueryGraphValue valueRight = this.getCreateValue(streamIdRight, streamIdLeft);
        valueRight.addRelOp(propertyRightExpr, QueryGraphRangeEnum.mapFrom(relationalOpEnum), propertyLeft, false);
    }

    public void addUnkeyedExpression(int indexedStream, String indexedProp, ExprNode exprNodeNoIdent) {
        if (indexedStream < 0 || indexedStream >= this.numStreams) {
            throw new IllegalArgumentException("Invalid indexed stream " + indexedStream);
        }
        for (int i = 0; i < this.numStreams; ++i) {
            if (i == indexedStream) continue;
            QueryGraphValue value = this.getCreateValue(i, indexedStream);
            value.addUnkeyedExpr(indexedProp, exprNodeNoIdent);
        }
    }

    public void addKeyedExpression(int indexedStream, String indexedProp, int keyExprStream, ExprNode exprNodeNoIdent) {
        this.check(indexedStream, keyExprStream);
        QueryGraphValue value = this.getCreateValue(keyExprStream, indexedStream);
        value.addKeyedExpr(indexedProp, exprNodeNoIdent);
    }

    private void check(int indexedStream, int keyStream) {
        if (indexedStream < 0 || indexedStream >= this.numStreams) {
            throw new IllegalArgumentException("Invalid indexed stream " + indexedStream);
        }
        if (keyStream < 0 || keyStream >= this.numStreams) {
            throw new IllegalArgumentException("Invalid key stream " + keyStream);
        }
        if (keyStream == indexedStream) {
            throw new IllegalArgumentException("Invalid key stream equals indexed stream " + keyStream);
        }
    }

    public void addRangeExpr(int indexedStream, String indexedProp, ExprNode startNode, Integer optionalStartStreamNum, ExprNode endNode, Integer optionalEndStreamNum) {
        QueryGraphValue value;
        if (optionalStartStreamNum == null && optionalEndStreamNum == null) {
            for (int i = 0; i < this.numStreams; ++i) {
                if (i == indexedStream) continue;
                QueryGraphValue value2 = this.getCreateValue(i, indexedStream);
                value2.addRange(QueryGraphRangeEnum.RANGE_CLOSED, startNode, endNode, indexedProp);
            }
            return;
        }
        if ((optionalStartStreamNum = Integer.valueOf(optionalStartStreamNum != null ? optionalStartStreamNum : -1)).equals(optionalEndStreamNum = Integer.valueOf(optionalEndStreamNum != null ? optionalEndStreamNum : -1)) || optionalEndStreamNum.equals(-1)) {
            value = this.getCreateValue(optionalStartStreamNum, indexedStream);
            value.addRange(QueryGraphRangeEnum.RANGE_CLOSED, startNode, endNode, indexedProp);
        }
        if (optionalStartStreamNum.equals(-1)) {
            value = this.getCreateValue(optionalEndStreamNum, indexedStream);
            value.addRange(QueryGraphRangeEnum.RANGE_CLOSED, startNode, endNode, indexedProp);
        }
    }

    public void addRelationalOp(int indexedStream, String indexedProp, Integer keyStreamNum, ExprNode exprNodeNoIdent, RelationalOpEnum relationalOpEnum) {
        if (keyStreamNum == null) {
            for (int i = 0; i < this.numStreams; ++i) {
                if (i == indexedStream) continue;
                QueryGraphValue value = this.getCreateValue(i, indexedStream);
                value.addRelOp(exprNodeNoIdent, QueryGraphRangeEnum.mapFrom(relationalOpEnum), indexedProp, false);
            }
            return;
        }
        QueryGraphValue value = this.getCreateValue(keyStreamNum, indexedStream);
        value.addRelOp(exprNodeNoIdent, QueryGraphRangeEnum.mapFrom(relationalOpEnum), indexedProp, false);
    }
}

