/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.join.plan.QueryGraphRangeConsolidateDesc;
import com.espertech.esper.epl.join.plan.QueryGraphRangeEnum;
import com.espertech.esper.epl.join.plan.QueryGraphRangeUtil;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntry;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyedExpr;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyedProp;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeIn;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeRelOp;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairHashKeyIndex;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairRangeIndex;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryGraphValue {
    private Map<String, QueryGraphValueEntry> entries = new LinkedHashMap<String, QueryGraphValueEntry>();

    public Map<String, QueryGraphValueEntry> getEntries() {
        return this.entries;
    }

    public boolean addStrictCompare(String keyProperty, ExprIdentNode keyPropNode, String indexProperty, ExprIdentNode indexPropNode) {
        QueryGraphValueEntryHashKeyedExpr expr;
        QueryGraphValueEntry value = this.entries.get(indexProperty);
        if (value instanceof QueryGraphValueEntryHashKeyedExpr && (expr = (QueryGraphValueEntryHashKeyedExpr)value).isConstant()) {
            return false;
        }
        if (value instanceof QueryGraphValueEntryHashKeyedProp) {
            return false;
        }
        this.entries.put(indexProperty, new QueryGraphValueEntryHashKeyedProp(keyPropNode, keyProperty));
        return true;
    }

    public void addRange(QueryGraphRangeEnum rangeType, ExprNode propertyStart, ExprNode propertyEnd, String propertyValue) {
        if (!rangeType.isRange()) {
            throw new IllegalArgumentException("Expected range type, received " + (Object)((Object)rangeType));
        }
        if (this.entries.containsKey(propertyValue)) {
            return;
        }
        this.entries.put(propertyValue, new QueryGraphValueEntryRangeIn(rangeType, propertyStart, propertyEnd, true));
    }

    public void addRelOp(ExprNode propertyKey, QueryGraphRangeEnum op, String propertyValue, boolean isBetweenOrIn) {
        QueryGraphValueEntry existing = this.entries.get(propertyValue);
        if (existing == null) {
            this.entries.put(propertyValue, new QueryGraphValueEntryRangeRelOp(op, propertyKey, isBetweenOrIn));
            return;
        }
        if (!(existing instanceof QueryGraphValueEntryRangeRelOp)) {
            return;
        }
        QueryGraphValueEntryRangeRelOp relOp = (QueryGraphValueEntryRangeRelOp)existing;
        QueryGraphRangeConsolidateDesc opsDesc = QueryGraphRangeUtil.getCanConsolidate(op, relOp.getType());
        if (opsDesc != null) {
            ExprNode start = !opsDesc.isReverse() ? relOp.getExpression() : propertyKey;
            ExprNode end = !opsDesc.isReverse() ? propertyKey : relOp.getExpression();
            this.entries.remove(propertyValue);
            this.addRange(opsDesc.getType(), start, end, propertyValue);
        }
    }

    public void addUnkeyedExpr(String indexedProp, ExprNode exprNodeNoIdent) {
        this.entries.put(indexedProp, new QueryGraphValueEntryHashKeyedExpr(exprNodeNoIdent, false));
    }

    public void addKeyedExpr(String indexedProp, ExprNode exprNodeNoIdent) {
        this.entries.put(indexedProp, new QueryGraphValueEntryHashKeyedExpr(exprNodeNoIdent, true));
    }

    public QueryGraphValuePairHashKeyIndex getHashKeyProps() {
        ArrayList<QueryGraphValueEntryHashKeyed> keys = new ArrayList<QueryGraphValueEntryHashKeyed>();
        ArrayDeque<String> indexed = new ArrayDeque<String>();
        for (Map.Entry<String, QueryGraphValueEntry> entry : this.entries.entrySet()) {
            if (!(entry.getValue() instanceof QueryGraphValueEntryHashKeyed)) continue;
            QueryGraphValueEntryHashKeyed keyprop = (QueryGraphValueEntryHashKeyed)entry.getValue();
            keys.add(keyprop);
            indexed.add(entry.getKey());
        }
        String[] strictKeys = new String[indexed.size()];
        int count = 0;
        for (Map.Entry<String, QueryGraphValueEntry> entry : this.entries.entrySet()) {
            if (!(entry.getValue() instanceof QueryGraphValueEntryHashKeyed)) continue;
            if (entry.getValue() instanceof QueryGraphValueEntryHashKeyedProp) {
                QueryGraphValueEntryHashKeyedProp keyprop = (QueryGraphValueEntryHashKeyedProp)entry.getValue();
                strictKeys[count] = keyprop.getKeyProperty();
            }
            ++count;
        }
        return new QueryGraphValuePairHashKeyIndex(indexed.toArray(new String[indexed.size()]), keys, strictKeys);
    }

    public QueryGraphValuePairRangeIndex getRangeProps() {
        ArrayDeque<String> indexed = new ArrayDeque<String>();
        ArrayList<QueryGraphValueEntryRange> keys = new ArrayList<QueryGraphValueEntryRange>();
        for (Map.Entry<String, QueryGraphValueEntry> entry : this.entries.entrySet()) {
            if (!(entry.getValue() instanceof QueryGraphValueEntryRange)) continue;
            QueryGraphValueEntryRange keyprop = (QueryGraphValueEntryRange)entry.getValue();
            keys.add(keyprop);
            indexed.add(entry.getKey());
        }
        return new QueryGraphValuePairRangeIndex(indexed.toArray(new String[indexed.size()]), keys);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.append("QueryGraphValue ");
        String delimiter = "";
        for (Map.Entry<String, QueryGraphValueEntry> entry : this.entries.entrySet()) {
            writer.append(delimiter);
            writer.append(entry.getKey() + ": " + entry.getValue());
            delimiter = ", ";
        }
        return writer.toString();
    }
}

