/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.util.UuidGenerator;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryPlanIndex {
    private Map<String, QueryPlanIndexItem> items;

    public QueryPlanIndex(Map<String, QueryPlanIndexItem> items) {
        if (items == null) {
            throw new IllegalArgumentException("Null value not allowed for items");
        }
        this.items = items;
    }

    public Map<String, QueryPlanIndexItem> getItems() {
        return this.items;
    }

    public static QueryPlanIndex makeIndex(QueryPlanIndexItem ... items) {
        LinkedHashMap<String, QueryPlanIndexItem> result = new LinkedHashMap<String, QueryPlanIndexItem>();
        for (QueryPlanIndexItem item : items) {
            result.put(UuidGenerator.generate(), item);
        }
        return new QueryPlanIndex(result);
    }

    public static QueryPlanIndex makeIndex(List<QueryPlanIndexItem> indexesSet) {
        LinkedHashMap<String, QueryPlanIndexItem> items = new LinkedHashMap<String, QueryPlanIndexItem>();
        for (QueryPlanIndexItem item : indexesSet) {
            items.put(UuidGenerator.generate(), item);
        }
        return new QueryPlanIndex(items);
    }

    protected String getIndexNum(String[] indexProps, String[] rangeProps) {
        QueryPlanIndexItem proposed = new QueryPlanIndexItem(indexProps, null, rangeProps, null);
        for (Map.Entry<String, QueryPlanIndexItem> entry : this.items.entrySet()) {
            if (!entry.getValue().equalsCompareSortedProps(proposed)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected String getFirstIndexNum() {
        return this.items.keySet().iterator().next();
    }

    public String addIndex(String[] indexProperties, Class[] coercionTypes) {
        String uuid = UuidGenerator.generate();
        this.items.put(uuid, new QueryPlanIndexItem(indexProperties, coercionTypes, null, null));
        return uuid;
    }

    public String[][] getIndexProps() {
        String[][] arr = new String[this.items.size()][];
        int count = 0;
        for (Map.Entry<String, QueryPlanIndexItem> entry : this.items.entrySet()) {
            arr[count] = entry.getValue().getIndexProps();
            ++count;
        }
        return arr;
    }

    public Class[] getCoercionTypes(String[] indexProperties) {
        for (Map.Entry<String, QueryPlanIndexItem> entry : this.items.entrySet()) {
            if (!Arrays.deepEquals(entry.getValue().getIndexProps(), indexProperties)) continue;
            return entry.getValue().getOptIndexCoercionTypes();
        }
        throw new IllegalArgumentException("Index properties not found");
    }

    public void setCoercionTypes(String[] indexProperties, Class[] coercionTypes) {
        boolean found = false;
        for (Map.Entry<String, QueryPlanIndexItem> entry : this.items.entrySet()) {
            if (!Arrays.deepEquals(entry.getValue().getIndexProps(), indexProperties)) continue;
            entry.getValue().setOptIndexCoercionTypes(coercionTypes);
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Index properties not found");
        }
    }

    public String toString() {
        if (this.items.isEmpty()) {
            return "    (none)";
        }
        StringBuilder buf = new StringBuilder();
        String delimiter = "";
        for (Map.Entry<String, QueryPlanIndexItem> entry : this.items.entrySet()) {
            buf.append(delimiter);
            buf.append("    item " + entry.getKey() + " : " + entry.getValue());
            delimiter = "\n";
        }
        return buf.toString();
    }

    public static String print(QueryPlanIndex[] indexSpecs) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("QueryPlanIndex[]\n");
        String delimiter = "";
        for (int i = 0; i < indexSpecs.length; ++i) {
            buffer.append(delimiter);
            buffer.append("  index spec stream " + i + " : \n" + (indexSpecs[i] == null ? "    null" : indexSpecs[i]));
            delimiter = "\n";
        }
        return buffer.toString() + "\n";
    }
}

