/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.join.plan.CoercionDesc;
import com.espertech.esper.epl.join.plan.CoercionUtil;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzer;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryGraphRangeConsolidateDesc;
import com.espertech.esper.epl.join.plan.QueryGraphRangeUtil;
import com.espertech.esper.epl.join.plan.QueryGraphValue;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyedExpr;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyedProp;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeIn;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeRelOp;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairHashKeyIndex;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairRangeIndex;
import com.espertech.esper.epl.join.plan.QueryPlanIndex;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.lookup.SubordPropHashKey;
import com.espertech.esper.epl.lookup.SubordPropPlan;
import com.espertech.esper.epl.lookup.SubordPropRangeKey;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class QueryPlanIndexBuilder {
    public static QueryPlanIndex[] buildIndexSpec(QueryGraph queryGraph, EventType[] typePerStream) {
        int numStreams = queryGraph.getNumStreams();
        QueryPlanIndex[] indexSpecs = new QueryPlanIndex[numStreams];
        for (int streamIndexed = 0; streamIndexed < numStreams; ++streamIndexed) {
            ArrayList<QueryPlanIndexItem> indexesSet = new ArrayList<QueryPlanIndexItem>();
            for (int streamLookup = 0; streamLookup < numStreams; ++streamLookup) {
                if (streamIndexed == streamLookup) continue;
                QueryGraphValue value = queryGraph.getGraphValue(streamLookup, streamIndexed);
                QueryGraphValuePairHashKeyIndex hashKeyAndIndexProps = value.getHashKeyProps();
                String[] hashIndexProps = hashKeyAndIndexProps.getIndexed();
                List<QueryGraphValueEntryHashKeyed> hashKeyProps = hashKeyAndIndexProps.getKeys();
                CoercionDesc indexCoercionTypes = CoercionUtil.getCoercionTypesHash(typePerStream, streamLookup, streamIndexed, hashKeyProps, hashIndexProps);
                QueryGraphValuePairRangeIndex rangeAndIndexProps = value.getRangeProps();
                String[] rangeIndexProps = rangeAndIndexProps.getIndexed();
                List<QueryGraphValueEntryRange> rangeKeyProps = rangeAndIndexProps.getKeys();
                CoercionDesc rangeCoercionTypes = CoercionUtil.getCoercionTypesRange(typePerStream, streamIndexed, rangeIndexProps, rangeKeyProps);
                if (hashIndexProps.length == 0 && rangeIndexProps.length == 0) continue;
                QueryPlanIndexItem proposed = new QueryPlanIndexItem(hashIndexProps, indexCoercionTypes.getCoercionTypes(), rangeIndexProps, rangeCoercionTypes.getCoercionTypes());
                boolean found = false;
                for (QueryPlanIndexItem index : indexesSet) {
                    if (!proposed.equalsCompareSortedProps(index)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                indexesSet.add(proposed);
            }
            if (indexesSet.isEmpty()) {
                indexesSet.add(new QueryPlanIndexItem(null, null, null, null));
            }
            indexSpecs[streamIndexed] = QueryPlanIndex.makeIndex(indexesSet);
        }
        return indexSpecs;
    }

    public static SubordPropPlan getJoinProps(ExprNode filterExpr, int outsideStreamCount, EventType[] allStreamTypesZeroIndexed) {
        if (filterExpr == null) {
            return new SubordPropPlan();
        }
        QueryGraph queryGraph = new QueryGraph(outsideStreamCount + 1);
        FilterExprAnalyzer.analyze(filterExpr, queryGraph, false);
        LinkedHashMap<String, SubordPropHashKey> joinProps = new LinkedHashMap<String, SubordPropHashKey>();
        LinkedHashMap<String, SubordPropRangeKey> rangeProps = new LinkedHashMap<String, SubordPropRangeKey>();
        for (int stream = 0; stream < outsideStreamCount; ++stream) {
            int lookupStream = stream + 1;
            QueryGraphValue queryGraphValue = queryGraph.getGraphValue(lookupStream, 0);
            QueryGraphValuePairHashKeyIndex hashKeysAndIndexes = queryGraphValue.getHashKeyProps();
            List<QueryGraphValueEntryHashKeyed> keyPropertiesJoin = hashKeysAndIndexes.getKeys();
            String[] indexPropertiesJoin = hashKeysAndIndexes.getIndexed();
            if (!keyPropertiesJoin.isEmpty()) {
                if (keyPropertiesJoin.size() != indexPropertiesJoin.length) {
                    throw new IllegalStateException("Invalid query key and index property collection for stream " + stream);
                }
                for (int i = 0; i < keyPropertiesJoin.size(); ++i) {
                    SubordPropHashKey desc;
                    Class indexedPropType;
                    QueryGraphValueEntryHashKeyed keyDesc = keyPropertiesJoin.get(i);
                    ExprNode compareNode = keyDesc.getKeyExpr();
                    Class keyPropType = JavaClassHelper.getBoxedType(compareNode.getExprEvaluator().getType());
                    Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(allStreamTypesZeroIndexed[0].getPropertyType(indexPropertiesJoin[i]));
                    if (keyPropType != indexedPropType) {
                        coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, indexedPropType);
                    }
                    if (keyPropertiesJoin.get(i) instanceof QueryGraphValueEntryHashKeyedExpr) {
                        QueryGraphValueEntryHashKeyedExpr keyExpr = (QueryGraphValueEntryHashKeyedExpr)keyPropertiesJoin.get(i);
                        Integer keyStreamNum = keyExpr.isRequiresKey() ? Integer.valueOf(stream) : null;
                        desc = new SubordPropHashKey(keyDesc, keyStreamNum, coercionType);
                    } else {
                        QueryGraphValueEntryHashKeyedProp prop = (QueryGraphValueEntryHashKeyedProp)keyDesc;
                        desc = new SubordPropHashKey(prop, stream, coercionType);
                    }
                    joinProps.put(indexPropertiesJoin[i], desc);
                }
            }
            QueryGraphValuePairRangeIndex rangeKeysAndIndexes = queryGraphValue.getRangeProps();
            String[] rangeIndexes = rangeKeysAndIndexes.getIndexed();
            List<QueryGraphValueEntryRange> rangeDescs = rangeKeysAndIndexes.getKeys();
            if (rangeDescs.isEmpty()) continue;
            int count = -1;
            for (QueryGraphValueEntryRange rangeDesc : rangeDescs) {
                String rangeIndexProp;
                SubordPropRangeKey subqRangeDesc;
                if ((subqRangeDesc = rangeProps.get(rangeIndexProp = rangeIndexes[++count])) != null) {
                    Class indexedPropType;
                    ExprNode end;
                    ExprNode start;
                    if (subqRangeDesc.getRangeInfo().getType().isRange()) continue;
                    QueryGraphValueEntryRangeRelOp relOpOther = (QueryGraphValueEntryRangeRelOp)subqRangeDesc.getRangeInfo();
                    QueryGraphValueEntryRangeRelOp relOpThis = (QueryGraphValueEntryRangeRelOp)rangeDesc;
                    QueryGraphRangeConsolidateDesc opsDesc = QueryGraphRangeUtil.getCanConsolidate(relOpThis.getType(), relOpOther.getType());
                    if (opsDesc == null) continue;
                    if (!opsDesc.isReverse()) {
                        start = relOpOther.getExpression();
                        end = relOpThis.getExpression();
                        int streamNumEnd = stream;
                    } else {
                        start = relOpThis.getExpression();
                        int streamNumStart = stream;
                        end = relOpOther.getExpression();
                    }
                    boolean allowRangeReversal = relOpOther.isBetweenPart() && relOpThis.isBetweenPart();
                    QueryGraphValueEntryRangeIn in = new QueryGraphValueEntryRangeIn(opsDesc.getType(), start, end, allowRangeReversal);
                    Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(allStreamTypesZeroIndexed[0].getPropertyType(rangeIndexProp));
                    Class proposedType = CoercionUtil.getCoercionTypeRangeIn(indexedPropType, in.getExprStart(), in.getExprEnd());
                    if (proposedType != null && proposedType != indexedPropType) {
                        coercionType = proposedType;
                    }
                    subqRangeDesc = new SubordPropRangeKey(in, coercionType);
                    rangeProps.put(rangeIndexProp, subqRangeDesc);
                    continue;
                }
                if (rangeDesc.getType().isRange()) {
                    Class indexedPropType;
                    QueryGraphValueEntryRangeIn in = (QueryGraphValueEntryRangeIn)rangeDesc;
                    Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(allStreamTypesZeroIndexed[0].getPropertyType(rangeIndexProp));
                    Class proposedType = CoercionUtil.getCoercionTypeRangeIn(indexedPropType, in.getExprStart(), in.getExprEnd());
                    if (proposedType != null && proposedType != indexedPropType) {
                        coercionType = proposedType;
                    }
                    subqRangeDesc = new SubordPropRangeKey(rangeDesc, coercionType);
                } else {
                    Class indexedPropType;
                    QueryGraphValueEntryRangeRelOp relOp = (QueryGraphValueEntryRangeRelOp)rangeDesc;
                    Class keyPropType = relOp.getExpression().getExprEvaluator().getType();
                    Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(allStreamTypesZeroIndexed[0].getPropertyType(rangeIndexProp));
                    if (keyPropType != indexedPropType) {
                        coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, indexedPropType);
                    }
                    subqRangeDesc = new SubordPropRangeKey(rangeDesc, coercionType);
                }
                rangeProps.put(rangeIndexProp, subqRangeDesc);
            }
        }
        return new SubordPropPlan(joinProps, rangeProps);
    }
}

