/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.pollindex;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyCompositeEventTableFactory;
import com.espertech.esper.epl.join.table.UnindexedEventTableList;
import java.util.Arrays;
import java.util.List;

public class PollResultIndexingStrategyComposite
implements PollResultIndexingStrategy {
    private final int streamNum;
    private final EventType eventType;
    private final String[] indexPropertiesJoin;
    private final Class[] keyCoercionTypes;
    private final String[] rangePropertiesJoin;
    private final Class[] rangeCoercionTypes;

    public PollResultIndexingStrategyComposite(int streamNum, EventType eventType, String[] indexPropertiesJoin, Class[] keyCoercionTypes, String[] rangePropertiesJoin, Class[] rangeCoercionTypes) {
        this.streamNum = streamNum;
        this.eventType = eventType;
        this.keyCoercionTypes = keyCoercionTypes;
        this.indexPropertiesJoin = indexPropertiesJoin;
        this.rangePropertiesJoin = rangePropertiesJoin;
        this.rangeCoercionTypes = rangeCoercionTypes;
    }

    @Override
    public EventTable index(List<EventBean> pollResult, boolean isActiveCache) {
        if (!isActiveCache) {
            return new UnindexedEventTableList(pollResult);
        }
        PropertyCompositeEventTableFactory factory = new PropertyCompositeEventTableFactory(this.streamNum, this.eventType, this.indexPropertiesJoin, this.keyCoercionTypes, this.rangePropertiesJoin, this.rangeCoercionTypes);
        EventTable table = factory.makeEventTable();
        table.add(pollResult.toArray(new EventBean[pollResult.size()]));
        return table;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " hash " + Arrays.toString(this.indexPropertiesJoin) + " btree " + Arrays.toString(this.rangePropertiesJoin) + " key coercion " + Arrays.toString(this.keyCoercionTypes) + " range coercion " + Arrays.toString(this.rangeCoercionTypes);
    }
}

