/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.rep;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.join.rep.Node;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class NodeCursorIterator
implements Iterator<Cursor> {
    private final Iterator<Node> nodeIterator;
    private final int stream;
    private Iterator<EventBean> currentIterator;
    private Node currentNode;

    public NodeCursorIterator(int stream, Iterator<Node> nodeIterator) {
        this.nodeIterator = nodeIterator;
        this.stream = stream;
        this.nextIterable();
    }

    @Override
    public Cursor next() {
        if (this.currentIterator == null) {
            throw new NoSuchElementException();
        }
        if (this.currentIterator.hasNext()) {
            return this.makeCursor(this.currentIterator.next());
        }
        this.nextIterable();
        if (this.currentIterator == null) {
            throw new NoSuchElementException();
        }
        return this.makeCursor(this.currentIterator.next());
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null) {
            return false;
        }
        if (this.currentIterator.hasNext()) {
            return true;
        }
        this.nextIterable();
        return this.currentIterator != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void nextIterable() {
        while (this.nodeIterator.hasNext()) {
            this.currentNode = this.nodeIterator.next();
            Set<EventBean> events = this.currentNode.getEvents();
            if (events == null) continue;
            this.currentIterator = events.iterator();
            if (!this.currentIterator.hasNext()) continue;
            return;
        }
        this.currentIterator = null;
    }

    private Cursor makeCursor(EventBean event) {
        return new Cursor(event, this.stream, this.currentNode);
    }
}

