/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexEnterRemove;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexEnterRemoveKeyed;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexEnterRemoveRange;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.PropertyCompositeEventTable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyCompositeEventTableFactory
implements EventTableFactory {
    private final int streamNum;
    private final String[] optionalKeyedProps;
    private final String[] rangeProps;
    private final CompositeIndexEnterRemove chain;
    private final Class[] optKeyCoercedTypes;
    private final Class[] optRangeCoercedTypes;
    private static Log log = LogFactory.getLog(PropertyCompositeEventTableFactory.class);

    public PropertyCompositeEventTableFactory(int streamNum, EventType eventType, String[] optionalKeyedProps, Class[] optKeyCoercedTypes, String[] rangeProps, Class[] optRangeCoercedTypes) {
        this.streamNum = streamNum;
        this.rangeProps = rangeProps;
        this.optionalKeyedProps = optionalKeyedProps;
        this.optKeyCoercedTypes = optKeyCoercedTypes;
        this.optRangeCoercedTypes = optRangeCoercedTypes;
        ArrayList<CompositeIndexEnterRemove> enterRemoves = new ArrayList<CompositeIndexEnterRemove>();
        if (optionalKeyedProps != null && optionalKeyedProps.length > 0) {
            enterRemoves.add(new CompositeIndexEnterRemoveKeyed(eventType, optionalKeyedProps, optKeyCoercedTypes));
        }
        int count = 0;
        for (String rangeProp : rangeProps) {
            Class coercionType = optRangeCoercedTypes == null ? null : optRangeCoercedTypes[count];
            enterRemoves.add(new CompositeIndexEnterRemoveRange(eventType, rangeProp, coercionType));
            ++count;
        }
        CompositeIndexEnterRemove last = null;
        for (CompositeIndexEnterRemove action : enterRemoves) {
            if (last != null) {
                last.setNext(action);
            }
            last = action;
        }
        this.chain = (CompositeIndexEnterRemove)enterRemoves.get(0);
    }

    @Override
    public EventTable makeEventTable() {
        return new PropertyCompositeEventTable(this.optionalKeyedProps != null && this.optionalKeyedProps.length > 0, this.chain, this.optKeyCoercedTypes, this.optRangeCoercedTypes);
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getName() + " streamNum=" + this.streamNum + " keys=" + Arrays.toString(this.optionalKeyedProps) + " ranges=" + Arrays.toString(this.rangeProps);
    }
}

