/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableIterator;
import com.espertech.esper.event.EventBeanUtility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyIndexedEventTable
implements EventTable {
    private final int streamNum;
    protected final EventPropertyGetter[] propertyGetters;
    protected final Map<MultiKeyUntyped, Set<EventBean>> propertyIndex;
    private static Log log = LogFactory.getLog(PropertyIndexedEventTable.class);

    public PropertyIndexedEventTable(int streamNum, EventPropertyGetter[] propertyGetters) {
        this.streamNum = streamNum;
        this.propertyGetters = propertyGetters;
        this.propertyIndex = new HashMap<MultiKeyUntyped, Set<EventBean>>();
    }

    protected MultiKeyUntyped getMultiKey(EventBean event) {
        return EventBeanUtility.getMultiKey(event, this.propertyGetters);
    }

    @Override
    public void add(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean event : events) {
            this.add(event);
        }
    }

    @Override
    public void remove(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean event : events) {
            this.remove(event);
        }
    }

    public Set<EventBean> lookup(Object[] keys) {
        MultiKeyUntyped key = new MultiKeyUntyped(keys);
        return this.propertyIndex.get(key);
    }

    private void add(EventBean event) {
        MultiKeyUntyped key = this.getMultiKey(event);
        Set<EventBean> events = this.propertyIndex.get(key);
        if (events == null) {
            events = new LinkedHashSet<EventBean>();
            this.propertyIndex.put(key, events);
        }
        events.add(event);
    }

    private void remove(EventBean event) {
        MultiKeyUntyped key = this.getMultiKey(event);
        Set<EventBean> events = this.propertyIndex.get(key);
        if (events == null) {
            return;
        }
        if (!events.remove(event)) {
            return;
        }
        if (events.isEmpty()) {
            this.propertyIndex.remove(key);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new PropertyIndexedEventTableIterator<MultiKeyUntyped>(this.propertyIndex);
    }

    @Override
    public void clear() {
        this.propertyIndex.clear();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.streamNum + " propertyGetters=" + Arrays.toString(this.propertyGetters);
    }
}

