/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyIndexedEventTableFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String[] propertyNames;
    protected final EventPropertyGetter[] propertyGetters;
    private static Log log = LogFactory.getLog(PropertyIndexedEventTableFactory.class);

    public PropertyIndexedEventTableFactory(int streamNum, EventType eventType, String[] propertyNames) {
        this.streamNum = streamNum;
        this.propertyNames = propertyNames;
        this.propertyGetters = new EventPropertyGetter[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            this.propertyGetters[i] = eventType.getGetter(propertyNames[i]);
        }
    }

    @Override
    public EventTable makeEventTable() {
        return new PropertyIndexedEventTable(this.streamNum, this.propertyGetters);
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.streamNum + " propertyNames=" + Arrays.toString(this.propertyNames);
    }
}

