/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyIndexedEventTableSingle
implements EventTable {
    private final int streamNum;
    protected final EventPropertyGetter propertyGetter;
    protected final Map<Object, Set<EventBean>> propertyIndex;
    private static Log log = LogFactory.getLog(PropertyIndexedEventTableSingle.class);

    public PropertyIndexedEventTableSingle(int streamNum, EventPropertyGetter propertyGetter) {
        this.streamNum = streamNum;
        this.propertyGetter = propertyGetter;
        this.propertyIndex = new HashMap<Object, Set<EventBean>>();
    }

    protected Object getKey(EventBean event) {
        return this.propertyGetter.get(event);
    }

    @Override
    public void add(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean event : events) {
            this.add(event);
        }
    }

    @Override
    public void remove(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean event : events) {
            this.remove(event);
        }
    }

    public Set<EventBean> lookup(Object key) {
        return this.propertyIndex.get(key);
    }

    private void add(EventBean event) {
        Object key = this.getKey(event);
        Set<EventBean> events = this.propertyIndex.get(key);
        if (events == null) {
            events = new LinkedHashSet<EventBean>();
            this.propertyIndex.put(key, events);
        }
        events.add(event);
    }

    private void remove(EventBean event) {
        Object key = this.getKey(event);
        Set<EventBean> events = this.propertyIndex.get(key);
        if (events == null) {
            return;
        }
        if (!events.remove(event)) {
            return;
        }
        if (events.isEmpty()) {
            this.propertyIndex.remove(key);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new PropertyIndexedEventTableIterator<Object>(this.propertyIndex);
    }

    @Override
    public void clear() {
        this.propertyIndex.clear();
    }

    public String toString() {
        return this.toQueryPlan();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.streamNum + " propertyGetter=" + this.propertyGetter;
    }
}

