/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.join.table.EventTable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class UnindexedEventTable
implements EventTable {
    private final int streamNum;
    private Set<EventBean> eventSet = new LinkedHashSet<EventBean>();

    public UnindexedEventTable(int streamNum) {
        this.streamNum = streamNum;
    }

    @Override
    public void clear() {
        this.eventSet.clear();
    }

    @Override
    public void add(EventBean[] addEvents) {
        if (addEvents == null) {
            return;
        }
        this.eventSet.addAll(Arrays.asList(addEvents));
    }

    @Override
    public void remove(EventBean[] removeEvents) {
        if (removeEvents == null) {
            return;
        }
        for (int i = 0; i < removeEvents.length; ++i) {
            this.eventSet.remove(removeEvents[i]);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.eventSet.isEmpty();
    }

    public Set<EventBean> getEventSet() {
        return this.eventSet;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.eventSet.iterator();
    }

    public String toString() {
        return this.toQueryPlan();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.streamNum;
    }
}

