/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import java.util.Arrays;
import java.util.Collection;

public class SubordIndexedTableLookupStrategyProp
implements SubordTableLookupStrategy {
    protected final int[] keyStreamNums;
    protected final EventPropertyGetter[] propertyGetters;
    protected final PropertyIndexedEventTable index;

    public SubordIndexedTableLookupStrategyProp(int[] keyStreamNums, EventPropertyGetter[] propertyGetters, PropertyIndexedEventTable index) {
        this.keyStreamNums = keyStreamNums;
        this.propertyGetters = propertyGetters;
        this.index = index;
    }

    public PropertyIndexedEventTable getIndex() {
        return this.index;
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        Object[] keys = this.getKeys(eventsPerStream);
        return this.index.lookup(keys);
    }

    @Override
    public Collection<EventBean> lookup(Object[] keys) {
        return this.index.lookup(keys);
    }

    protected Object[] getKeys(EventBean[] eventsPerStream) {
        Object[] keyValues = new Object[this.propertyGetters.length];
        for (int i = 0; i < this.propertyGetters.length; ++i) {
            int streamNum = this.keyStreamNums[i];
            EventBean event = eventsPerStream[streamNum];
            keyValues[i] = this.propertyGetters[i].get(event);
        }
        return keyValues;
    }

    public String toString() {
        return this.toQueryPlan();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " keyStreamNums=" + Arrays.toString(this.keyStreamNums);
    }
}

