/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableUtil;
import com.espertech.esper.epl.named.IndexMultiKey;
import com.espertech.esper.epl.named.IndexedPropDesc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NamedWindowIndexRepository {
    private static final Log log = LogFactory.getLog(NamedWindowIndexRepository.class);
    private List<EventTable> tables = new ArrayList<EventTable>();
    private Map<IndexMultiKey, Pair<EventTable, Integer>> tableIndexesRefCount = new HashMap<IndexMultiKey, Pair<EventTable, Integer>>();

    public Pair<IndexMultiKey, EventTable> addTableCreateOrReuse(List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps, Iterable<EventBean> prefilledEvents, EventType indexedType, boolean mustCoerce) {
        if (hashProps.isEmpty() && btreeProps.isEmpty()) {
            throw new IllegalArgumentException("Invalid zero element list for hash and btree columns");
        }
        IndexMultiKey indexPropKeyMatch = this.findExactMatchNameAndType(this.tableIndexesRefCount.keySet(), hashProps, btreeProps);
        if (indexPropKeyMatch != null) {
            Pair<EventTable, Integer> refTablePair = this.tableIndexesRefCount.get(indexPropKeyMatch);
            refTablePair.setSecond(refTablePair.getSecond() + 1);
            return new Pair<IndexMultiKey, EventTable>(indexPropKeyMatch, refTablePair.getFirst());
        }
        IndexMultiKey indexPropKey = new IndexMultiKey(hashProps, btreeProps);
        IndexedPropDesc[] indexedPropDescs = hashProps.toArray(new IndexedPropDesc[hashProps.size()]);
        String[] indexProps = IndexedPropDesc.getIndexProperties(indexedPropDescs);
        Class[] indexCoercionTypes = IndexedPropDesc.getCoercionTypes(indexedPropDescs);
        if (!mustCoerce) {
            indexCoercionTypes = null;
        }
        IndexedPropDesc[] rangePropDescs = btreeProps.toArray(new IndexedPropDesc[btreeProps.size()]);
        String[] rangeProps = IndexedPropDesc.getIndexProperties(rangePropDescs);
        Class[] rangeCoercionTypes = IndexedPropDesc.getCoercionTypes(rangePropDescs);
        QueryPlanIndexItem indexItem = new QueryPlanIndexItem(indexProps, indexCoercionTypes, rangeProps, rangeCoercionTypes);
        EventTable table = EventTableUtil.buildIndex(0, indexItem, indexedType, true);
        EventBean[] events = new EventBean[1];
        Iterator<EventBean> i$ = prefilledEvents.iterator();
        while (i$.hasNext()) {
            EventBean prefilledEvent;
            events[0] = prefilledEvent = i$.next();
            table.add(events);
        }
        this.tables.add(table);
        this.tableIndexesRefCount.put(indexPropKey, new Pair<EventTable, Integer>(table, 1));
        return new Pair<IndexMultiKey, EventTable>(indexPropKey, table);
    }

    private IndexMultiKey findExactMatchNameAndType(Set<IndexMultiKey> indexMultiKeys, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps) {
        for (IndexMultiKey existing : indexMultiKeys) {
            if (!this.isExactMatch(existing, hashProps, btreeProps)) continue;
            return existing;
        }
        return null;
    }

    private boolean isExactMatch(IndexMultiKey existing, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps) {
        boolean keyPropCompare = IndexedPropDesc.compare(Arrays.asList(existing.getHashIndexedProps()), hashProps);
        return keyPropCompare && IndexedPropDesc.compare(Arrays.asList(existing.getRangeIndexedProps()), btreeProps);
    }

    public void addTableReference(EventTable table) {
        for (Map.Entry<IndexMultiKey, Pair<EventTable, Integer>> entry : this.tableIndexesRefCount.entrySet()) {
            if (entry.getValue().getFirst() != table) continue;
            int current = entry.getValue().getSecond() + 1;
            entry.getValue().setSecond(current);
        }
    }

    public void removeTableReference(EventTable table) {
        for (Map.Entry<IndexMultiKey, Pair<EventTable, Integer>> entry : this.tableIndexesRefCount.entrySet()) {
            if (entry.getValue().getFirst() != table) continue;
            int current = entry.getValue().getSecond();
            if (current > 1) {
                entry.getValue().setSecond(--current);
                break;
            }
            this.tables.remove(table);
            this.tableIndexesRefCount.remove(entry.getKey());
            break;
        }
    }

    public List<EventTable> getTables() {
        return this.tables;
    }

    public void destroy() {
        this.tables.clear();
        this.tableIndexesRefCount.clear();
    }

    public Pair<IndexMultiKey, EventTable> findTable(Set<String> keyPropertyNames, Set<String> rangePropertyNames, Map<String, EventTable> explicitIndexNames) {
        if (keyPropertyNames.isEmpty() && rangePropertyNames.isEmpty()) {
            return null;
        }
        ArrayList<IndexMultiKey> candidateTables = null;
        for (Map.Entry<IndexMultiKey, Pair<EventTable, Integer>> entry : this.tableIndexesRefCount.entrySet()) {
            String[] rangeIndexProps;
            String[] indexedProps;
            boolean missed = false;
            for (String indexedProp : indexedProps = IndexedPropDesc.getIndexProperties(entry.getKey().getHashIndexedProps())) {
                if (keyPropertyNames.contains(indexedProp)) continue;
                missed = true;
                break;
            }
            for (String rangeProp : rangeIndexProps = IndexedPropDesc.getIndexProperties(entry.getKey().getRangeIndexedProps())) {
                if (rangePropertyNames.contains(rangeProp) || keyPropertyNames.contains(rangeProp)) continue;
                missed = true;
                break;
            }
            if (missed) continue;
            if (candidateTables == null) {
                candidateTables = new ArrayList<IndexMultiKey>();
            }
            candidateTables.add(entry.getKey());
        }
        if (candidateTables == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No index found.");
            }
            return null;
        }
        if (candidateTables.size() > 1) {
            Comparator<IndexMultiKey> comparator = new Comparator<IndexMultiKey>(){

                @Override
                public int compare(IndexMultiKey o1, IndexMultiKey o2) {
                    String[] indexedProps2;
                    String[] indexedProps1 = IndexedPropDesc.getIndexProperties(o1.getHashIndexedProps());
                    if (indexedProps1.length > (indexedProps2 = IndexedPropDesc.getIndexProperties(o2.getHashIndexedProps())).length) {
                        return -1;
                    }
                    if (indexedProps1.length == indexedProps2.length) {
                        return 0;
                    }
                    return 1;
                }
            };
            Collections.sort(candidateTables, comparator);
        }
        IndexMultiKey indexMultiKey = (IndexMultiKey)candidateTables.get(0);
        EventTable tableFound = this.tableIndexesRefCount.get(indexMultiKey).getFirst();
        if (log.isDebugEnabled()) {
            String indexName = null;
            for (Map.Entry<String, EventTable> entry : explicitIndexNames.entrySet()) {
                if (entry.getValue() != tableFound) continue;
                indexName = entry.getKey();
            }
            log.debug((Object)("Found index " + indexName + " for on-demand query"));
        }
        return new Pair<IndexMultiKey, EventTable>(indexMultiKey, tableFound);
    }

    public IndexMultiKey[] getIndexDescriptors() {
        Set<IndexMultiKey> keySet = this.tableIndexesRefCount.keySet();
        return keySet.toArray(new IndexMultiKey[keySet.size()]);
    }
}

