/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.InternalEventRouter;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.SelectExprProcessorFactory;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.named.NamedWindowOnMergeAction;
import com.espertech.esper.epl.named.NamedWindowOnMergeActionDel;
import com.espertech.esper.epl.named.NamedWindowOnMergeActionIns;
import com.espertech.esper.epl.named.NamedWindowOnMergeActionUpd;
import com.espertech.esper.epl.named.NamedWindowOnMergeMatch;
import com.espertech.esper.epl.named.NamedWindowUpdateHelper;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.OnTriggerMergeAction;
import com.espertech.esper.epl.spec.OnTriggerMergeActionDelete;
import com.espertech.esper.epl.spec.OnTriggerMergeActionInsert;
import com.espertech.esper.epl.spec.OnTriggerMergeActionUpdate;
import com.espertech.esper.epl.spec.OnTriggerMergeDesc;
import com.espertech.esper.epl.spec.OnTriggerMergeMatched;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.util.UuidGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class NamedWindowOnMergeHelper {
    private List<NamedWindowOnMergeMatch> matched = new ArrayList<NamedWindowOnMergeMatch>();
    private List<NamedWindowOnMergeMatch> unmatched = new ArrayList<NamedWindowOnMergeMatch>();

    public NamedWindowOnMergeHelper(StatementContext statementContext, OnTriggerMergeDesc onTriggerDesc, EventType triggeringEventType, String triggeringStreamName, InternalEventRouter internalEventRouter, String namedWindowName, EventTypeSPI namedWindowType) throws ExprValidationException {
        int count = 1;
        for (OnTriggerMergeMatched matchedItem : onTriggerDesc.getItems()) {
            ArrayList<NamedWindowOnMergeAction> actions = new ArrayList<NamedWindowOnMergeAction>();
            for (OnTriggerMergeAction item : matchedItem.getActions()) {
                try {
                    if (item instanceof OnTriggerMergeActionInsert) {
                        OnTriggerMergeActionInsert insertDesc = (OnTriggerMergeActionInsert)item;
                        actions.add(this.setupInsert(namedWindowName, internalEventRouter, namedWindowType, count, insertDesc, triggeringEventType, triggeringStreamName, statementContext));
                    } else if (item instanceof OnTriggerMergeActionUpdate) {
                        OnTriggerMergeActionUpdate updateDesc = (OnTriggerMergeActionUpdate)item;
                        NamedWindowUpdateHelper updateHelper = NamedWindowUpdateHelper.make(namedWindowType, updateDesc.getAssignments(), onTriggerDesc.getOptionalAsName());
                        ExprEvaluator filterEval = updateDesc.getOptionalWhereClause() == null ? null : updateDesc.getOptionalWhereClause().getExprEvaluator();
                        actions.add(new NamedWindowOnMergeActionUpd(filterEval, updateHelper));
                    } else if (item instanceof OnTriggerMergeActionDelete) {
                        OnTriggerMergeActionDelete deleteDesc = (OnTriggerMergeActionDelete)item;
                        ExprEvaluator filterEval = deleteDesc.getOptionalWhereClause() == null ? null : deleteDesc.getOptionalWhereClause().getExprEvaluator();
                        actions.add(new NamedWindowOnMergeActionDel(filterEval));
                    } else {
                        throw new IllegalArgumentException("Invalid type of merge item '" + item.getClass() + "'");
                    }
                    ++count;
                }
                catch (ExprValidationException ex) {
                    boolean isNot = item instanceof OnTriggerMergeActionInsert;
                    String message = "Exception encountered in when-" + (isNot ? "not-" : "") + "matched (clause " + count + "): " + ex.getMessage();
                    throw new ExprValidationException(message, ex);
                }
            }
            if (matchedItem.isMatchedUnmatched()) {
                this.matched.add(new NamedWindowOnMergeMatch(matchedItem.getOptionalMatchCond(), actions));
                continue;
            }
            this.unmatched.add(new NamedWindowOnMergeMatch(matchedItem.getOptionalMatchCond(), actions));
        }
    }

    private NamedWindowOnMergeActionIns setupInsert(String namedWindowName, InternalEventRouter internalEventRouter, EventTypeSPI eventTypeNamedWindow, int selectClauseNumber, OnTriggerMergeActionInsert desc, EventType triggeringEventType, String triggeringStreamName, StatementContext statementContext) throws ExprValidationException {
        String streamName = desc.getOptionalStreamName() != null ? desc.getOptionalStreamName() : eventTypeNamedWindow.getName();
        List<SelectClauseElementCompiled> selectClause = desc.getSelectClauseCompiled();
        InsertIntoDesc insertIntoDesc = new InsertIntoDesc(true, streamName);
        for (String col : desc.getColumns()) {
            insertIntoDesc.add(col);
        }
        if (triggeringStreamName == null) {
            triggeringStreamName = UuidGenerator.generate();
        }
        ArrayList<SelectClauseElementCompiled> selectNoWildcard = new ArrayList<SelectClauseElementCompiled>();
        for (SelectClauseElementCompiled element : selectClause) {
            if (!(element instanceof SelectClauseElementWildcard)) {
                selectNoWildcard.add(element);
                continue;
            }
            SelectClauseStreamCompiledSpec streamSelect = new SelectClauseStreamCompiledSpec(triggeringStreamName, null);
            streamSelect.setStreamNumber(1);
            selectNoWildcard.add(streamSelect);
        }
        MapEventType dummyTypeNoProperties = new MapEventType(EventTypeMetadata.createAnonymous("merge_named_window_insert"), "merge_named_window_insert", 0, null, Collections.<String, Object>emptyMap(), null, null, null);
        EventType[] eventTypes = new EventType[]{dummyTypeNoProperties, triggeringEventType};
        String[] streamNames = new String[]{UuidGenerator.generate(), triggeringStreamName};
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(eventTypes, streamNames, new boolean[1], statementContext.getEngineURI(), false);
        SelectExprEventTypeRegistry selectExprEventTypeRegistry = new SelectExprEventTypeRegistry(new HashSet<String>());
        ExprEvaluatorContextStatement exprEvaluatorContext = new ExprEvaluatorContextStatement(statementContext);
        SelectExprProcessor insertHelper = SelectExprProcessorFactory.getProcessor(Collections.singleton(selectClauseNumber), selectNoWildcard, false, insertIntoDesc, null, streamTypeService, statementContext.getEventAdapterService(), statementContext.getStatementResultService(), statementContext.getValueAddEventService(), selectExprEventTypeRegistry, statementContext.getMethodResolutionService(), exprEvaluatorContext, statementContext.getVariableService(), statementContext.getTimeProvider(), statementContext.getEngineURI(), statementContext.getStatementId(), statementContext.getStatementName(), statementContext.getAnnotations(), statementContext.getContextDescriptor());
        ExprEvaluator filterEval = desc.getOptionalWhereClause() == null ? null : desc.getOptionalWhereClause().getExprEvaluator();
        InternalEventRouter routerToUser = streamName.equals(namedWindowName) ? null : internalEventRouter;
        return new NamedWindowOnMergeActionIns(filterEval, insertHelper, routerToUser, statementContext.getEpStatementHandle(), statementContext.getInternalEventEngineRouteDest());
    }

    public List<NamedWindowOnMergeMatch> getMatched() {
        return this.matched;
    }

    public List<NamedWindowOnMergeMatch> getUnmatched() {
        return this.unmatched;
    }
}

