/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.named.NamedWindowLookupStrategy;
import com.espertech.esper.epl.named.NamedWindowOnExprBaseView;
import com.espertech.esper.epl.named.NamedWindowOnSelectViewFactory;
import com.espertech.esper.epl.named.NamedWindowRootViewInstance;
import com.espertech.esper.event.EventBeanUtility;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NamedWindowOnSelectView
extends NamedWindowOnExprBaseView {
    private static final Log log = LogFactory.getLog(NamedWindowOnSelectView.class);
    private final NamedWindowOnSelectViewFactory parent;
    private final ResultSetProcessor resultSetProcessor;
    private EventBean[] lastResult;
    private Set<MultiKey<EventBean>> oldEvents = new HashSet<MultiKey<EventBean>>();

    public NamedWindowOnSelectView(NamedWindowLookupStrategy lookupStrategy, NamedWindowRootViewInstance rootView, ExprEvaluatorContext exprEvaluatorContext, NamedWindowOnSelectViewFactory parent, ResultSetProcessor resultSetProcessor) {
        super(lookupStrategy, rootView, exprEvaluatorContext);
        this.parent = parent;
        this.resultSetProcessor = resultSetProcessor;
    }

    @Override
    public void handleMatching(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        EventBean[] newData;
        this.resultSetProcessor.clear();
        LinkedHashSet<MultiKey<EventBean>> newEvents = new LinkedHashSet<MultiKey<EventBean>>();
        for (int i = 0; i < triggerEvents.length; ++i) {
            EventBean triggerEvent = triggerEvents[0];
            if (matchingEvents == null) continue;
            for (int j = 0; j < matchingEvents.length; ++j) {
                EventBean[] eventsPerStream = new EventBean[]{matchingEvents[j], triggerEvent};
                newEvents.add(new MultiKey<EventBean>(eventsPerStream));
            }
        }
        UniformPair<EventBean[]> pair = this.resultSetProcessor.processJoinResult(newEvents, this.oldEvents, false);
        EventBean[] eventBeanArray = newData = pair != null ? pair.getFirst() : null;
        if (this.parent.isDistinct()) {
            newData = EventBeanUtility.getDistinctByProp(newData, this.parent.getEventBeanReader());
        }
        if (this.parent.getInternalEventRouter() != null && newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                this.parent.getInternalEventRouter().route(newData[i], this.parent.getStatementHandle(), this.parent.getInternalEventRouteDest(), this.getExprEvaluatorContext(), this.parent.isAddToFront());
            }
        }
        if (newData != null && newData.length > 0 && (this.parent.getStatementResultService().isMakeNatural() || this.parent.getStatementResultService().isMakeSynthetic())) {
            this.updateChildren(newData, null);
        }
        this.lastResult = newData;
        this.resultSetProcessor.clear();
    }

    @Override
    public EventType getEventType() {
        if (this.resultSetProcessor != null) {
            return this.resultSetProcessor.getResultEventType();
        }
        return this.rootView.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new ArrayEventIterator(this.lastResult);
    }
}

